/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.PolyPointEditHandle;
import org.jhotdraw8.draw.handle.PolyPointMoveHandle;
import org.jhotdraw8.draw.handle.PolylineOutlineHandle;
import org.jhotdraw8.draw.key.Point2DListStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class PolylineFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
TransformableFigure,
ResizableFigure,
PathIterableFigure {
    public static final Point2DListStyleableKey POINTS = new Point2DListStyleableKey("points", (ImmutableList<Point2D>)VectorList.of());
    public static final String TYPE_SELECTOR = "Polyline";

    public PolylineFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public PolylineFigure(double startX, double startY, double endX, double endY) {
        this.set((MapAccessor)POINTS, VectorList.of((Object[])new Point2D[]{new Point2D(startX, startY), new Point2D(endX, endY)}));
        this.set((MapAccessor)FILL, null);
    }

    public PolylineFigure(Point2D ... points) {
        this.set((MapAccessor)POINTS, VectorList.of((Object[])points));
        this.set((MapAccessor)FILL, null);
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new PolylineOutlineHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, false));
        } else if (handleType == HandleType.MOVE) {
            list.add(new PolylineOutlineHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, false));
            int n = ((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).size();
            for (int i = 0; i < n; ++i) {
                list.add(new PolyPointMoveHandle(this, (MapAccessor<ImmutableList<Point2D>>)POINTS, i));
            }
        } else if (handleType == HandleType.POINT) {
            list.add(new PolylineOutlineHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, true));
            int n = ((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).size();
            for (int i = 0; i < n; ++i) {
                list.add(new PolyPointEditHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, i));
            }
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Polyline n = new Polyline();
        n.setManaged(false);
        return n;
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point2D p : (ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)) {
            minX = Math.min(minX, p.getX());
            minY = Math.min(minY, p.getY());
            maxX = Math.max(maxX, p.getX());
            maxY = Math.max(maxY, p.getY());
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        return FXShapes.awtPathIteratorFromFxPoint2Ds((List)((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).asList(), (boolean)false, (int)1, (AffineTransform)tx);
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        List newP = ((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).toMutable();
        int n = newP.size();
        for (int i = 0; i < n; ++i) {
            newP.set(i, FXTransforms.transform((Transform)transform, (Point2D)((Point2D)newP.get(i))));
        }
        this.set((MapAccessor)POINTS, VectorList.copyOf((Iterable)newP));
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D t) {
        List newP = ((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).toMutable();
        int n = newP.size();
        for (int i = 0; i < n; ++i) {
            newP.set(i, ((Point2D)newP.get(i)).add(t.getConvertedValue()));
        }
        this.set((MapAccessor)POINTS, VectorList.copyOf((Iterable)newP));
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Polyline lineNode = (Polyline)node;
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyStrokableFigureProperties(ctx, (Shape)lineNode);
        this.applyFillableFigureProperties(ctx, (Shape)lineNode);
        this.applyTransformableFigureProperties(ctx, node);
        this.applyCompositableFigureProperties(ctx, (Node)lineNode);
        ImmutableList points = (ImmutableList)this.getStyledNonNull(POINTS);
        ArrayList<Double> list = new ArrayList<Double>(points.size() * 2);
        for (Point2D p : points) {
            list.add(p.getX());
            list.add(p.getY());
        }
        lineNode.getPoints().setAll(list);
        lineNode.applyCss();
    }

    public static double @NonNull [] toPointArray(@NonNull Figure f, @NonNull NonNullMapAccessor<? extends ImmutableList<Point2D>> key) {
        ImmutableList points = (ImmutableList)f.getNonNull(key);
        double[] a = new double[points.size() * 2];
        int i = 0;
        int n = points.size();
        int j = 0;
        while (i < n) {
            Point2D p = (Point2D)points.get(i);
            a[j] = p.getX();
            a[j + 1] = p.getY();
            ++i;
            j += 2;
        }
        return a;
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x.getConvertedValue(), (double)y.getConvertedValue(), (double)width.getConvertedValue(), (double)height.getConvertedValue()));
    }
}

