/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.RectangleConnector;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.RectangularFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.SymmetricCssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;

public class RectangleFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
TransformableFigure,
ResizableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ConnectableFigure,
PathIterableFigure,
RectangularFigure {
    public static final String TYPE_SELECTOR = "Rectangle";
    public static final @NonNull CssSizeStyleableKey ARC_HEIGHT = new CssSizeStyleableKey("arcHeight", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey ARC_WIDTH = new CssSizeStyleableKey("arcWidth", CssSize.ZERO);
    public static final @Nullable SymmetricCssPoint2DStyleableMapAccessor ARC = new SymmetricCssPoint2DStyleableMapAccessor("arc", (NonNullMapAccessor<CssSize>)ARC_WIDTH, (NonNullMapAccessor<CssSize>)ARC_HEIGHT);

    public RectangleFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public RectangleFigure(double x, double y, double width, double height) {
        this.reshapeInLocal(x, y, width, height);
    }

    public RectangleFigure(@NonNull Rectangle2D rect) {
        this(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        Rectangle shape = new Rectangle();
        shape.setX(((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue());
        shape.setY(((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue());
        shape.setWidth(((CssSize)this.getNonNull((NonNullMapAccessor)WIDTH)).getConvertedValue());
        shape.setHeight(((CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT)).getConvertedValue());
        shape.setArcWidth(((CssSize)this.getStyledNonNull(ARC_WIDTH)).getConvertedValue());
        shape.setArcHeight(((CssSize)this.getStyledNonNull(ARC_HEIGHT)).getConvertedValue());
        this.applyFillableFigureProperties(ctx, (Shape)shape);
        this.applyStrokableFigureProperties(ctx, (Shape)shape);
        return FXShapes.awtShapeFromFX((Shape)shape).getPathIterator(tx);
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Rectangle n = new Rectangle();
        n.setManaged(false);
        return n;
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Rectangle rectangleNode = (Rectangle)node;
        this.applyHideableFigureProperties(ctx, node);
        this.applyTransformableFigureProperties(ctx, (Node)rectangleNode);
        this.applyFillableFigureProperties(ctx, (Shape)rectangleNode);
        this.applyStrokableFigureProperties(ctx, (Shape)rectangleNode);
        this.applyCompositableFigureProperties(ctx, (Node)rectangleNode);
        this.applyStyleableFigureProperties(ctx, node);
        rectangleNode.setX(((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue());
        rectangleNode.setY(((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue());
        rectangleNode.setWidth(((CssSize)this.getNonNull((NonNullMapAccessor)WIDTH)).getConvertedValue());
        rectangleNode.setHeight(((CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT)).getConvertedValue());
        rectangleNode.setArcWidth(((CssSize)this.getStyledNonNull(ARC_WIDTH)).getConvertedValue());
        rectangleNode.setArcHeight(((CssSize)this.getStyledNonNull(ARC_HEIGHT)).getConvertedValue());
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new RectangleConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

