/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.shape.Path;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssInsets;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssInsetsStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.NullableSvgPathStyleableKey;
import org.jhotdraw8.draw.key.Rectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.AwtPathBuilder;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.NineRegionsScalingBuilder;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.SvgPaths;

public interface ShapeableFigure
extends Figure {
    public static final @NonNull CssSizeStyleableKey SHAPE_SLICE_BOTTOM = new CssSizeStyleableKey("shapeSliceBottom", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey SHAPE_SLICE_LEFT = new CssSizeStyleableKey("shapeSliceLeft", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey SHAPE_SLICE_RIGHT = new CssSizeStyleableKey("shapeSliceRight", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey SHAPE_SLICE_TOP = new CssSizeStyleableKey("shapeSliceTop", CssSize.ZERO);
    public static final @NonNull CssInsetsStyleableMapAccessor SHAPE_SLICE = new CssInsetsStyleableMapAccessor("shapeSlice", (NonNullMapAccessor<CssSize>)SHAPE_SLICE_TOP, (NonNullMapAccessor<CssSize>)SHAPE_SLICE_RIGHT, (NonNullMapAccessor<CssSize>)SHAPE_SLICE_BOTTOM, (NonNullMapAccessor<CssSize>)SHAPE_SLICE_LEFT);
    public static final @NonNull DoubleStyleableKey SHAPE_BOUNDS_X = new DoubleStyleableKey("shapeBoundsX", 0.0);
    public static final @NonNull DoubleStyleableKey SHAPE_BOUNDS_Y = new DoubleStyleableKey("shapeBoundsY", 0.0);
    public static final @NonNull DoubleStyleableKey SHAPE_BOUNDS_WIDTH = new DoubleStyleableKey("shapeBoundsWidth", 0.0);
    public static final @NonNull DoubleStyleableKey SHAPE_BOUNDS_HEIGHT = new DoubleStyleableKey("shapeBoundsHeight", 0.0);
    public static final @NonNull Rectangle2DStyleableMapAccessor SHAPE_BOUNDS = new Rectangle2DStyleableMapAccessor("shapeBounds", (NonNullMapAccessor<Double>)SHAPE_BOUNDS_X, (NonNullMapAccessor<Double>)SHAPE_BOUNDS_Y, (NonNullMapAccessor<Double>)SHAPE_BOUNDS_WIDTH, (NonNullMapAccessor<Double>)SHAPE_BOUNDS_HEIGHT);
    public static final @NonNull NullableSvgPathStyleableKey SHAPE = new NullableSvgPathStyleableKey("shape", null);
    public static final @NonNull String SVG_SQUARE = "M 0,0 1,0 1,1 0,1 Z";

    default public void applyShapeableProperties(RenderContext ctx, @NonNull Path node) {
        this.applyShapeableProperties(ctx, node, this.getLayoutBounds());
    }

    default public void applyShapeableProperties(RenderContext ctx, @NonNull Path node, @NonNull Bounds b) {
        String content = (String)this.getStyled((MapAccessor)SHAPE);
        if (content == null || content.trim().isEmpty()) {
            content = SVG_SQUARE;
        }
        try {
            AwtPathBuilder builder = new AwtPathBuilder(new Path2D.Double());
            SvgPaths.svgStringToBuilder((String)content, (PathBuilder)builder);
            Path2D.Double path = builder.build();
            Rectangle2D shapeBounds = (Rectangle2D)this.getStyled((MapAccessor)SHAPE_BOUNDS);
            BoundingBox srcBounds = shapeBounds == null || FXRectangles.isEmpty((Rectangle2D)shapeBounds) ? FXRectangles.getBounds((Shape)path) : FXRectangles.getBounds((Rectangle2D)shapeBounds);
            Insets shapeSlice = ((CssInsets)this.getStyledNonNull(SHAPE_SLICE)).getConvertedValue(srcBounds.getWidth(), srcBounds.getHeight());
            FXPathElementsBuilder builder2 = new FXPathElementsBuilder();
            NineRegionsScalingBuilder nineRegionsScalingBuilder = new NineRegionsScalingBuilder((PathBuilder)builder2, (Bounds)srcBounds, shapeSlice, b);
            AwtShapes.buildFromPathIterator((PathBuilder)nineRegionsScalingBuilder, (PathIterator)path.getPathIterator(null));
            List elements = (List)nineRegionsScalingBuilder.build();
            node.getElements().setAll((Collection)elements);
            node.setVisible(true);
        }
        catch (ParseException ex) {
            node.setVisible(false);
        }
    }
}

