/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.PathConnector;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PaddableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.RectangularFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.ShapeableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TextEditableFigure;
import org.jhotdraw8.draw.figure.TextFillableFigure;
import org.jhotdraw8.draw.figure.TextFontableFigure;
import org.jhotdraw8.draw.figure.TextLayoutableFigure;
import org.jhotdraw8.draw.figure.TextableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.SimpleRenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXShapes;

public class TextAreaFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
TransformableFigure,
ResizableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ConnectableFigure,
PathIterableFigure,
RectangularFigure,
ShapeableFigure,
TextableFigure,
TextFontableFigure,
TextLayoutableFigure,
TextFillableFigure,
PaddableFigure,
TextEditableFigure {
    public static final String TYPE_SELECTOR = "TextArea";
    private Path path;

    @Override
    public @NonNull Node createNode(@NonNull RenderContext ctx) {
        Group n = new Group();
        n.setManaged(false);
        n.setAutoSizeChildren(false);
        Path p = new Path();
        Text text = new Text();
        n.getChildren().addAll((Object[])new Node[]{p, text});
        return n;
    }

    @Override
    public @NonNull TextEditableFigure.TextEditorData getTextEditorDataFor(@Nullable Point2D pointInLocal, Node node) {
        return new TextEditableFigure.TextEditorData(this, this.getLayoutBounds(), (MapAccessor<String>)TEXT);
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Group g = (Group)node;
        Path p = (Path)g.getChildren().get(0);
        Text text = (Text)g.getChildren().get(1);
        this.applyShapeableProperties(ctx, p);
        this.applyStrokableFigureProperties(ctx, (Shape)p);
        this.applyFillableFigureProperties(ctx, (Shape)p);
        this.applyTextFontableFigureProperties(ctx, text);
        this.applyTextLayoutableFigureProperties(ctx, text);
        text.setText((String)this.getStyled((MapAccessor)TEXT));
        this.applyTextFillableFigureProperties(ctx, text);
        this.applyTransformableFigureProperties(ctx, node);
        UnitConverter converter = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        Insets padding = this.getStyledNonNull(PADDING).getConvertedValue(converter);
        double size = text.getFont().getSize();
        Bounds bounds = this.getLayoutBounds();
        double y = switch (text.getTextOrigin()) {
            default -> bounds.getMinY() + padding.getTop();
            case VPos.CENTER -> bounds.getMinY() + bounds.getHeight() * 0.5;
            case VPos.BASELINE -> bounds.getMinY() + size + padding.getTop();
            case VPos.BOTTOM -> bounds.getMaxY() - padding.getBottom();
        };
        text.setX(bounds.getMinX() + padding.getLeft());
        text.setY(y);
        text.setWrappingWidth(bounds.getWidth() - padding.getLeft() - padding.getRight());
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        if (this.path == null) {
            this.path = new Path();
        }
        this.applyShapeableProperties(ctx, this.path);
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D pointInLocal, Figure connectingFigure, double tolerance) {
        return new PathConnector(new BoundsLocator(this.getLayoutBounds(), pointInLocal));
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        if (this.path == null) {
            this.layout(new SimpleRenderContext());
        }
        return this.path == null ? AwtShapes.emptyPathIterator() : FXShapes.awtShapeFromFX((Shape)this.path).getPathIterator(tx);
    }
}

