/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import javafx.scene.control.Labeled;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssFont;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.FontStyleableMapAccessor;
import org.jhotdraw8.draw.key.NonNullBooleanStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.key.StringOrIdentStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public interface TextFontableFigure
extends Figure {
    public static final StringOrIdentStyleableKey FONT_FAMILY = new StringOrIdentStyleableKey("fontFamily", "Arial");
    public static final CssSizeStyleableKey FONT_SIZE = new CssSizeStyleableKey("fontSize", CssSize.of((double)12.0));
    public static final NonNullEnumStyleableKey<FontPosture> FONT_STYLE = new NonNullEnumStyleableKey<FontPosture>("fontStyle", FontPosture.class, FontPosture.REGULAR);
    public static final NonNullEnumStyleableKey<FontWeight> FONT_WEIGHT = new NonNullEnumStyleableKey<FontWeight>("fontWeight", FontWeight.class, FontWeight.NORMAL);
    public static final FontStyleableMapAccessor FONT = new FontStyleableMapAccessor("font", (MapAccessor<String>)FONT_FAMILY, (MapAccessor<FontWeight>)FONT_WEIGHT, (MapAccessor<FontPosture>)FONT_STYLE, (MapAccessor<CssSize>)FONT_SIZE);
    public static final NonNullBooleanStyleableKey STRIKETHROUGH = new NonNullBooleanStyleableKey("strikethrough", false);
    public static final NonNullBooleanStyleableKey UNDERLINE = new NonNullBooleanStyleableKey("underline", false);

    default public void applyTextFontableFigureProperties(@Nullable RenderContext ctx, @NonNull Text text) {
        FontSmoothingType fst;
        String family = (String)this.getStyledNonNull((NonNullMapAccessor)FONT_FAMILY);
        FontPosture style = (FontPosture)this.getStyledNonNull((NonNullMapAccessor)FONT_STYLE);
        FontWeight weight = (FontWeight)this.getStyledNonNull((NonNullMapAccessor)FONT_WEIGHT);
        DefaultUnitConverter units = ctx == null ? DefaultUnitConverter.getInstance() : (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        CssSize cssSize = (CssSize)this.getStyledNonNull((NonNullMapAccessor)FONT_SIZE);
        double size = units.convert(cssSize, "");
        CssFont f = CssFont.font(family, weight, style, size);
        Font font = f.getFont();
        if (!text.getFont().equals((Object)font)) {
            text.setFont(font);
        }
        boolean b = (Boolean)this.getStyledNonNull((NonNullMapAccessor)UNDERLINE);
        if (text.isUnderline() != b) {
            text.setUnderline(b);
        }
        b = (Boolean)this.getStyledNonNull((NonNullMapAccessor)STRIKETHROUGH);
        if (text.isStrikethrough() != b) {
            text.setStrikethrough(b);
        }
        FontSmoothingType fontSmoothingType = fst = ctx == null || ctx.getNonNull((NonNullMapAccessor)RenderContext.RENDERING_INTENT) == RenderingIntent.EDITOR ? FontSmoothingType.LCD : FontSmoothingType.GRAY;
        if (text.getFontSmoothingType() != fst) {
            text.setFontSmoothingType(fst);
        }
    }

    default public void applyTextFontableFigureProperties(@Nullable RenderContext ctx, @NonNull Labeled text) {
        DefaultUnitConverter units = ctx == null ? DefaultUnitConverter.getInstance() : (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        Font font = ((CssFont)this.getStyledNonNull(FONT)).getFont();
        if (!text.getFont().equals((Object)font)) {
            text.setFont(font);
        }
        boolean b = (Boolean)this.getStyledNonNull((NonNullMapAccessor)UNDERLINE);
        if (text.isUnderline() == b) {
            text.setUnderline(b);
        }
    }
}

