/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.geom.FXTransforms;

public interface TransformCachingFigure
extends Figure {
    public static final boolean CACHE = true;

    public @Nullable Transform getCachedLocalToWorld();

    public void setCachedLocalToWorld(@Nullable Transform var1);

    public @Nullable Transform getCachedParentToWorld();

    public void setCachedParentToWorld(@Nullable Transform var1);

    public @Nullable Transform getCachedWorldToLocal();

    public void setCachedWorldToLocal(@Nullable Transform var1);

    public @Nullable Transform getCachedWorldToParent();

    public void setCachedWorldToParent(@Nullable Transform var1);

    @Override
    default public @NonNull Transform getParentToWorld() {
        Transform t = this.getCachedParentToWorld();
        if (t == null) {
            t = this.getParent() == null ? FXTransforms.IDENTITY : this.getParent().getLocalToWorld();
            this.setCachedParentToWorld(t);
        }
        return t;
    }

    @Override
    default public @NonNull Transform getLocalToWorld() {
        Transform t = this.getCachedLocalToWorld();
        if (t == null) {
            t = this.getLocalToParent();
            Figure parent = this.getParent();
            t = parent == null ? t : FXTransforms.concat((Transform[])new Transform[]{parent.getLocalToWorld(), t});
            this.setCachedLocalToWorld(t);
        }
        return t;
    }

    @Override
    default public @NonNull Transform getWorldToLocal() {
        Transform t = this.getCachedWorldToLocal();
        if (t == null) {
            t = this.getParentToLocal();
            Figure parent = this.getParent();
            t = parent == null ? t : FXTransforms.concat((Transform[])new Transform[]{t, parent.getWorldToLocal()});
            this.setCachedWorldToLocal(t);
        }
        return t;
    }

    @Override
    default public @NonNull Transform getWorldToParent() {
        Transform t = this.getCachedWorldToParent();
        if (t == null) {
            Figure parent = this.getParent();
            t = parent == null ? FXTransforms.IDENTITY : parent.getWorldToLocal();
            this.setCachedWorldToParent(t);
        }
        return t;
    }

    public @Nullable Transform getCachedLocalToParent();

    public void setCachedLocalToParent(@Nullable Transform var1);

    public @Nullable Transform getCachedParentToLocal();

    public void setCachedParentToLocal(@Nullable Transform var1);

    @Override
    default public void invalidateTransforms() {
        this.setCachedWorldToLocal(null);
        this.setCachedWorldToParent(null);
        this.setCachedLocalToWorld(null);
        this.setCachedParentToWorld(null);
        this.setCachedParentToLocal(null);
        this.setCachedLocalToParent(null);
    }
}

