/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.constrain.Constrainer;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.ConnectingFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXGeom;
import org.jhotdraw8.geom.Points;

public abstract class AbstractConnectorHandle
extends AbstractHandle {
    protected final @NonNull MapAccessor<Connector> connectorKey;
    protected final NonNullMapAccessor<CssPoint2D> pointKey;
    protected final @NonNull MapAccessor<Figure> targetKey;
    protected @Nullable Point2D connectorLocation;
    protected Point2D pickLocation;
    private boolean isConnected;
    private boolean isDragging;
    private boolean editable = true;
    private @Nullable Figure prevTarget;

    public AbstractConnectorHandle(@NonNull ConnectingFigure figure, NonNullMapAccessor<CssPoint2D> pointKey, @NonNull MapAccessor<Connector> connectorKey, @NonNull MapAccessor<Figure> targetKey) {
        super(figure);
        this.pointKey = pointKey;
        this.connectorKey = connectorKey;
        this.targetKey = targetKey;
        this.isConnected = figure.get(connectorKey) != null && figure.get(targetKey) != null;
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        boolean b = false;
        if (this.connectorLocation != null) {
            boolean bl = b = Points.squaredDistance((double)x, (double)y, (double)this.connectorLocation.getX(), (double)this.connectorLocation.getY()) <= tolerance * tolerance;
        }
        if (!b && this.pickLocation != null) {
            b = Points.squaredDistance((double)x, (double)y, (double)this.pickLocation.getX(), (double)this.pickLocation.getY()) <= tolerance * tolerance;
        }
        return b;
    }

    @Override
    public Cursor getCursor() {
        return this.isDragging ? Cursor.CLOSED_HAND : Cursor.HAND;
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    @Override
    public @NonNull ConnectingFigure getOwner() {
        return (ConnectingFigure)super.getOwner();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (!this.editable) {
            return;
        }
        this.isDragging = true;
        Point2D pointInView = new Point2D(event.getX(), event.getY());
        Point2D unconstrainedPointInWorld = view.viewToWorld(pointInView);
        DrawingEditor editor = view.getEditor();
        double tolerance1 = editor == null ? 0.1 : editor.getTolerance();
        double tolerance = view.getViewToWorld().deltaTransform(tolerance1, 0.0).getX();
        Constrainer constrainer = view.getConstrainer();
        CssPoint2D constrainedPointInWorld = constrainer != null && !event.isAltDown() && !event.isControlDown() ? constrainer.constrainPoint(this.owner, new CssPoint2D(unconstrainedPointInWorld)) : new CssPoint2D(unconstrainedPointInWorld);
        ConnectingFigure o = this.getOwner();
        Connector newConnector = null;
        Figure newConnectedFigure = null;
        this.isConnected = false;
        DrawingModel model = view.getModel();
        model.set(o, this.targetKey, null);
        if (!event.isMetaDown()) {
            if (event.isShiftDown() && this.prevTarget != null) {
                newConnectedFigure = this.prevTarget;
                ConnectableFigure cff = (ConnectableFigure)this.prevTarget;
                ConnectorAndConnectedFigure connectorAndConnectedFigure = this.find(constrainedPointInWorld, o, cff, event, tolerance);
                Connector connector = newConnector = connectorAndConnectedFigure == null ? null : connectorAndConnectedFigure.connector();
                if (newConnector != null && o.canConnect(cff, newConnector)) {
                    newConnectedFigure = connectorAndConnectedFigure.connectedFigure();
                    constrainedPointInWorld = new CssPoint2D((Point2D)newConnector.getPointAndDerivativeInLocal(o, cff).getPoint(Point2D::new));
                    this.isConnected = true;
                }
            } else {
                List<Figure> list = view.findFigures(pointInView, true).stream().map(Map.Entry::getKey).toList();
                double closestDistanceSq = Double.POSITIVE_INFINITY;
                for (int i = list.size() - 1; i >= 0; --i) {
                    Figure f1 = list.get(i);
                    for (Figure ff : f1.breadthFirstIterable()) {
                        Point2D p;
                        double distanceSq;
                        ConnectorAndConnectedFigure candidate;
                        Connector candidateConnector;
                        if (this.owner == ff || !(ff instanceof ConnectableFigure)) continue;
                        ConnectableFigure cff = (ConnectableFigure)ff;
                        Point2D pointInLocal = cff.worldToLocal(unconstrainedPointInWorld);
                        if (!ff.getBoundsInLocal().contains(pointInLocal) || (candidateConnector = (candidate = this.find(constrainedPointInWorld, o, cff, event, tolerance)) == null ? null : candidate.connector()) == null || !o.canConnect(ff, newConnector) || !((distanceSq = FXGeom.distanceSq((Point2D)(p = (Point2D)candidate.connector().getPointAndDerivativeInWorld(this.owner, candidate.connectedFigure()).getPoint(Point2D::new)), (Point2D)unconstrainedPointInWorld)) <= closestDistanceSq)) continue;
                        closestDistanceSq = distanceSq;
                        newConnectedFigure = candidate.connectedFigure();
                        newConnector = candidateConnector;
                        this.isConnected = true;
                    }
                }
            }
        }
        model.set(o, this.pointKey, this.owner.worldToLocal(constrainedPointInWorld));
        model.set(o, this.connectorKey, newConnector);
        model.set(o, this.targetKey, newConnectedFigure);
    }

    protected @Nullable ConnectorAndConnectedFigure find(@NonNull CssPoint2D pointInWorld, @NonNull ConnectingFigure o, @NonNull ConnectableFigure cff, @NonNull MouseEvent mouseEvent, double tolerance) {
        Connector connector = cff.findConnector(cff.worldToLocal(pointInWorld.getConvertedValue()), o, tolerance);
        return connector == null ? null : new ConnectorAndConnectedFigure(connector, cff);
    }

    @Override
    public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
        this.prevTarget = (Figure)this.owner.get(this.targetKey);
    }

    protected void onPopupTriggered(MouseEvent event, DrawingView view) {
    }

    @Override
    public void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
        this.isDragging = false;
    }

    public record ConnectorAndConnectedFigure(@NonNull Connector connector, @NonNull Figure connectedFigure) {
    }
}

