/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXGeom;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierControlPointEditHandle
extends AbstractHandle {
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final @Nullable Border REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, null, null)});
    private static final Path REGION_SHAPE_COLINEAR = new Path();
    private static final Rectangle REGION_SHAPE_CUSP = new Rectangle(5.0, 5.0);
    private static final Path REGION_SHAPE_EQUIDISTANT = new Path();
    private static final Circle REGION_SHAPE_SMOOTH = new Circle(0.0, 0.0, 3.0);
    private final int controlPointMask;
    private final @NonNull Region node;
    private Point2D pickLocation;
    private final int nodeIndex;
    private final @NonNull MapAccessor<BezierPath> pathKey;

    public BezierControlPointEditHandle(@NonNull Figure figure, @NonNull MapAccessor<BezierPath> pathKey, int nodeIndex, int controlPointMask) {
        super(figure);
        this.pathKey = pathKey;
        this.nodeIndex = nodeIndex;
        this.controlPointMask = controlPointMask;
        if (this.controlPointMask != 2 && this.controlPointMask != 4) {
            throw new IllegalArgumentException("controlPoint:" + controlPointMask);
        }
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE_CUSP);
        this.node.setManaged(false);
        this.node.setScaleShape(true);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.node.setBorder(REGION_BORDER);
        this.node.setBackground(REGION_BACKGROUND);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return p != null && Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    private @Nullable BezierNode getBezierNode() {
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        return path == null || path.size() <= this.nodeIndex ? null : path.get(this.nodeIndex);
    }

    @Override
    public Cursor getCursor() {
        return Cursor.CROSSHAIR;
    }

    private @NonNull Point2D getLocation() {
        BezierNode bezierNode = this.getBezierNode();
        return bezierNode == null ? Point2D.ZERO : (Point2D)bezierNode.getC(this.controlPointMask, Point2D::new);
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public @NonNull Region getNode(@NonNull DrawingView view) {
        DrawingEditor editor = view.getEditor();
        if (editor == null) {
            return this.node;
        }
        double size = editor.getHandleSize() * 0.8;
        if (this.node.getWidth() != size) {
            this.node.resize(size, size);
        }
        CssColor color = editor.getHandleColor();
        BorderStroke borderStroke = (BorderStroke)this.node.getBorder().getStrokes().getFirst();
        if (!borderStroke.getTopStroke().equals(color.getColor())) {
            this.node.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)color.getColor(), BorderStrokeStyle.SOLID, null, null)}));
        }
        return this.node;
    }

    @Override
    public void onMouseClicked(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (event.getClickCount() == 1 && (event.isControlDown() || event.isAltDown())) {
            BezierNode bn = this.getBezierNode();
            if (bn == null) {
                return;
            }
            BezierPath path = (BezierPath)this.owner.get(this.pathKey);
            if (path == null) {
                return;
            }
            BezierNode newbn = bn.isCollinear() ? (bn.isEquidistant() ? bn.withCollinear(false).withEquidistant(false) : bn.withCollinear(true).withEquidistant(true)) : bn.withCollinear(true).withEquidistant(false);
            dv.getModel().set(this.owner, this.pathKey, path.set(this.nodeIndex, newbn));
        }
    }

    @Override
    public void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        Point2D newPoint = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        Figure f = this.getOwner();
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(f, new CssPoint2D(newPoint)).getConvertedValue();
        }
        BezierPath list = (BezierPath)this.owner.get(this.pathKey);
        BezierNode bn = this.getBezierNode();
        if (bn == null) {
            return;
        }
        Point2D p = f.worldToLocal(newPoint);
        if (!bn.isCollinear()) {
            if (!bn.isEquidistant()) {
                BezierNode newBezierNode = bn.withC(this.controlPointMask, p.getX(), p.getY());
                view.getModel().set(f, this.pathKey, list.set(this.nodeIndex, newBezierNode));
            } else {
                BezierNode newBezierNode = bn.withC(this.controlPointMask, p.getX(), p.getY());
                Point2D c0 = (Point2D)bn.getPoint(Point2D::new);
                double r = p.distance(c0);
                if (this.controlPointMask == 2) {
                    Point2D p2 = (Point2D)bn.getOut(Point2D::new);
                    Point2D dir = p2.subtract(c0).normalize();
                    if (dir.magnitude() == 0.0) {
                        dir = new Point2D(0.0, 1.0);
                    }
                    p2 = c0.add(dir.multiply(r));
                    Point2D constrainedPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(p2)).getConvertedValue();
                    if (Points.almostEqual((double)p2.getX(), (double)p2.getY(), (double)constrainedPoint.getX(), (double)constrainedPoint.getY())) {
                        p2 = constrainedPoint;
                    }
                    newBezierNode = newBezierNode.withOut(p2.getX(), p2.getY());
                } else {
                    Point2D p2 = (Point2D)bn.getIn(Point2D::new);
                    Point2D dir = p2.subtract(c0).normalize();
                    if (dir.magnitude() == 0.0) {
                        dir = new Point2D(0.0, 1.0);
                    }
                    p2 = c0.add(dir.multiply(r));
                    Point2D constrainedPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(p2)).getConvertedValue();
                    if (Points.almostEqual((double)p2.getX(), (double)p2.getY(), (double)constrainedPoint.getX(), (double)constrainedPoint.getY())) {
                        p2 = constrainedPoint;
                    }
                    newBezierNode = newBezierNode.withIn(p2.getX(), p2.getY());
                }
                view.getModel().set(f, this.pathKey, list.set(this.nodeIndex, newBezierNode));
            }
        } else {
            Point2D c0 = (Point2D)bn.getPoint(Point2D::new);
            double a = Math.PI + FXGeom.angle((Point2D)c0, (Point2D)p);
            Point2D p2 = this.controlPointMask == 2 ? (Point2D)bn.getOut(Point2D::new) : (Point2D)bn.getIn(Point2D::new);
            double r = bn.isEquidistant() ? Math.sqrt((p.getX() - c0.getX()) * (p.getX() - c0.getX()) + (p.getY() - c0.getY()) * (p.getY() - c0.getY())) : Math.sqrt((p2.getX() - c0.getX()) * (p2.getX() - c0.getX()) + (p2.getY() - c0.getY()) * (p2.getY() - c0.getY()));
            double sina = Math.sin(a);
            double cosa = Math.cos(a);
            p2 = new Point2D(Math.fma(r, cosa, c0.getX()), Math.fma(r, sina, c0.getY()));
            Point2D constrainedPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(p2)).getConvertedValue();
            if (Points.almostEqual((double)p2.getX(), (double)p2.getY(), (double)constrainedPoint.getX(), (double)constrainedPoint.getY())) {
                p2 = constrainedPoint;
            }
            BezierNode newBezierNode = this.controlPointMask == 2 ? bn.withIn(p.getX(), p.getY()).withOut(p2.getX(), p2.getY()) : bn.withOut(p.getX(), p.getY()).withIn(p2.getX(), p2.getY());
            view.getModel().set(f, this.pathKey, list.set(this.nodeIndex, newBezierNode));
        }
    }

    @Override
    public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
    }

    private void onPopupTriggered(@NonNull MouseEvent event, @NonNull DrawingView view) {
        BezierPath nullablePath = (BezierPath)this.owner.get(this.pathKey);
        if (nullablePath == null) {
            return;
        }
        ContextMenu contextMenu = new ContextMenu();
        Menu constraints = new Menu(DrawLabels.getResources().getString("handle.bezierControlPoint.constraints.text"));
        RadioMenuItem noneRadio = new RadioMenuItem(DrawLabels.getResources().getString("handle.bezierControlPoint.noConstraints.text"));
        RadioMenuItem collinearRadio = new RadioMenuItem(DrawLabels.getResources().getString("handle.bezierControlPoint.collinearConstraint.text"));
        RadioMenuItem equidistantRadio = new RadioMenuItem(DrawLabels.getResources().getString("handle.bezierControlPoint.equidistantConstraint.text"));
        RadioMenuItem bothRadio = new RadioMenuItem(DrawLabels.getResources().getString("handle.bezierControlPoint.collinearAndEquidistantConstraint.text"));
        BezierPath[] path = new BezierPath[]{nullablePath};
        BezierNode bnode = path[0].get(this.nodeIndex);
        if (bnode.isEquidistant() && bnode.isCollinear()) {
            bothRadio.setSelected(true);
        } else if (bnode.isEquidistant()) {
            equidistantRadio.setSelected(true);
        } else if (bnode.isCollinear()) {
            collinearRadio.setSelected(true);
        } else {
            noneRadio.setSelected(true);
        }
        noneRadio.setOnAction(actionEvent -> {
            BezierNode changedNode = bnode.withCollinear(false).withEquidistant(false);
            path[0] = path[0].set(this.nodeIndex, changedNode);
            view.getModel().set(this.owner, this.pathKey, path[0]);
            view.recreateHandles();
        });
        collinearRadio.setOnAction(actionEvent -> {
            BezierNode changedNode = bnode.withCollinear(true).withEquidistant(false);
            path[0] = path[0].set(this.nodeIndex, changedNode);
            view.getModel().set(this.owner, this.pathKey, path[0]);
            view.recreateHandles();
        });
        equidistantRadio.setOnAction(actionEvent -> {
            BezierNode changedNode = bnode.withCollinear(false).withEquidistant(true);
            path[0] = path[0].set(this.nodeIndex, changedNode);
            view.getModel().set(this.owner, this.pathKey, path[0]);
            view.recreateHandles();
        });
        bothRadio.setOnAction(actionEvent -> {
            BezierNode changedNode = bnode.withCollinear(true).withEquidistant(true);
            path[0] = path[0].set(this.nodeIndex, changedNode);
            view.getModel().set(this.owner, this.pathKey, path[0]);
            view.recreateHandles();
        });
        constraints.getItems().addAll((Object[])new MenuItem[]{noneRadio, collinearRadio, equidistantRadio, bothRadio});
        contextMenu.getItems().add((Object)constraints);
        contextMenu.show((Node)this.node, event.getScreenX(), event.getScreenY());
        event.consume();
    }

    @Override
    public void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        if (path == null) {
            this.node.setVisible(false);
            return;
        }
        BezierNode bnode = this.getBezierNode();
        if (bnode == null || (bnode.getMask() & this.controlPointMask) != this.controlPointMask) {
            this.node.setVisible(false);
            return;
        }
        this.node.setVisible(true);
        Point2D cp = this.getLocation();
        this.pickLocation = cp = FXTransforms.transform((Transform)t, (Point2D)cp);
        double size = this.node.getWidth();
        this.node.relocate(cp.getX() - size * 0.5, cp.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
        BezierNode bn = this.getBezierNode();
        if (bn == null) {
            return;
        }
        if (bn.isCollinear()) {
            if (bn.isEquidistant()) {
                this.node.setShape((Shape)REGION_SHAPE_SMOOTH);
            } else {
                this.node.setShape((Shape)REGION_SHAPE_COLINEAR);
            }
        } else if (bn.isEquidistant()) {
            this.node.setShape((Shape)REGION_SHAPE_EQUIDISTANT);
        } else {
            this.node.setShape((Shape)REGION_SHAPE_CUSP);
        }
        this.node.setVisible(bn.hasMaskBits(this.controlPointMask));
    }

    static {
        ObservableList elements = REGION_SHAPE_COLINEAR.getElements();
        elements.add((Object)new MoveTo(2.0, 0.0));
        elements.add((Object)new LineTo(4.0, 0.0));
        elements.add((Object)new LineTo(6.0, 2.0));
        elements.add((Object)new LineTo(6.0, 4.0));
        elements.add((Object)new LineTo(4.0, 6.0));
        elements.add((Object)new LineTo(2.0, 6.0));
        elements.add((Object)new LineTo(0.0, 4.0));
        elements.add((Object)new LineTo(0.0, 2.0));
        elements.add((Object)new ClosePath());
        elements.add((Object)new MoveTo(3.0, 0.0));
        elements.add((Object)new LineTo(3.0, 6.0));
        elements = REGION_SHAPE_EQUIDISTANT.getElements();
        elements.add((Object)new MoveTo(0.0, 0.0));
        elements.add((Object)new LineTo(3.0, -3.0));
        elements.add((Object)new LineTo(6.0, 0.0));
        elements.add((Object)new LineTo(3.0, 3.0));
        elements.add((Object)new ClosePath());
    }
}

