/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.geometry.Point2D;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.BezierPathOutlineHandle;
import org.jhotdraw8.draw.undo.RecreateHandlesEdit;
import org.jhotdraw8.fxbase.undo.CompositeEdit;
import org.jhotdraw8.fxbase.undo.FXUndoManager;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierPathEditHandle
extends BezierPathOutlineHandle {
    private final MapAccessor<BezierPath> pointKey;

    public BezierPathEditHandle(Figure figure, MapAccessor<BezierPath> pointKey) {
        super(figure, pointKey, true);
        this.pointKey = pointKey;
    }

    @Override
    public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
    }

    private void onPopupTriggered(@NonNull MouseEvent event, @NonNull DrawingView view) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem addPoint = new MenuItem(DrawLabels.getResources().getString("handle.addPoint.text"));
        addPoint.setOnAction(actionEvent -> this.addPoint(event, view));
        contextMenu.getItems().add((Object)addPoint);
        contextMenu.show(this.getNode(view), event.getScreenX(), event.getScreenY());
        event.consume();
    }

    private void addPoint(@NonNull MouseEvent event, @NonNull DrawingView view) {
        Point2D pointInLocal;
        IntersectionResult intersectionResultEx;
        BezierPath path = (BezierPath)this.owner.get(this.pointKey);
        if (path == null) {
            path = BezierPath.of();
        }
        if (!(intersectionResultEx = path.pathIntersection((pointInLocal = this.owner.worldToLocal(view.viewToWorld(event.getX(), event.getY()))).getX(), pointInLocal.getY(), view.getEditor().getTolerance())).intersections().isEmpty()) {
            IntersectionPoint intersectionPointEx = (IntersectionPoint)intersectionResultEx.intersections().get(0);
            int segment = intersectionPointEx.getSegmentA();
            BezierNode newNode = new BezierNode(intersectionPointEx.getX(), intersectionPointEx.getY());
            if (segment > 0 && path.get(segment - 1).isClosePath()) {
                path = path.set(segment - 1, path.get(segment - 1).withMaskBitsClears(16));
                newNode = newNode.withMaskBitsSet(16);
            }
            int inNodeIndex = (path.size() + segment - 1) % path.size();
            BezierNode inNode = path.get(inNodeIndex);
            int outNodeIndex = (path.size() + segment) % path.size();
            BezierNode outNode = path.get(outNodeIndex);
            if (inNode.hasOut() && outNode.hasIn()) {
                split = new double[14];
                CubicCurves.split((double[])new double[]{inNode.pointX(), inNode.pointY(), inNode.outX(), inNode.outY(), outNode.inX(), outNode.inY(), outNode.pointX(), outNode.pointY()}, (int)0, (double)intersectionPointEx.getArgumentA(), (double[])split, (int)0, (double[])split, (int)6);
                inNode = inNode.withOut(split[2], split[3]);
                newNode = newNode.withIn(split[4], split[5]).withOut(split[8], split[9]).withMaskBitsSet(6);
                outNode = outNode.withIn(split[10], split[11]);
            } else if (inNode.hasOut()) {
                split = new double[10];
                QuadCurves.split((double[])new double[]{inNode.pointX(), inNode.pointY(), inNode.outX(), inNode.outY(), outNode.pointX(), outNode.pointY()}, (int)0, (double)intersectionPointEx.getArgumentA(), (double[])split, (int)0, (double[])split, (int)4);
                inNode = inNode.withOut(split[2], split[3]);
                newNode = newNode.withOut(split[6], split[7]).withMaskBitsSet(4);
            } else if (outNode.hasIn()) {
                split = new double[10];
                QuadCurves.split((double[])new double[]{inNode.pointX(), inNode.pointY(), outNode.inX(), outNode.inY(), outNode.pointX(), outNode.pointY()}, (int)0, (double)intersectionPointEx.getArgumentA(), (double[])split, (int)0, (double[])split, (int)4);
                newNode = newNode.withIn(split[2], split[3]).withMaskBitsSet(2);
                outNode = outNode.withIn(split[6], split[7]);
            }
            path = path.set(inNodeIndex, inNode).set(outNodeIndex, outNode).add(segment, newNode);
            CompositeEdit compoundEdit = new CompositeEdit(DrawLabels.getResources().getString("handle.addPoint.text"));
            FXUndoManager undoManager = view.getEditor().getUndoManager();
            undoManager.undoableEditHappened(new UndoableEditEvent(this, (UndoableEdit)compoundEdit));
            undoManager.undoableEditHappened(new UndoableEditEvent(this, new RecreateHandlesEdit(view)));
            view.getModel().set(this.owner, this.pointKey, path);
            view.recreateHandles();
            undoManager.undoableEditHappened(new UndoableEditEvent(this, new RecreateHandlesEdit(view)));
            undoManager.undoableEditHappened(new UndoableEditEvent(this, (UndoableEdit)compoundEdit));
        }
    }

    @Override
    public void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return true;
    }
}

