/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.awt.geom.PathIterator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.FXGeom;
import org.jhotdraw8.geom.FXLines;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierPathOutlineHandle
extends AbstractHandle {
    private final @NonNull Group node;
    private final @NonNull Path path2;
    private final @NonNull Path path1;
    private double strokeWidth = 1.0;
    private final @NonNull MapAccessor<BezierPath> bezierPathKey;
    private final boolean selectable;

    public BezierPathOutlineHandle(@NonNull Figure figure, @NonNull MapAccessor<BezierPath> pointKey, boolean selectable) {
        super(figure);
        this.bezierPathKey = pointKey;
        this.node = new Group();
        this.path2 = new Path();
        this.path1 = new Path();
        this.node.getChildren().addAll((Object[])new Node[]{this.path1, this.path2});
        this.selectable = selectable;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public boolean contains(DrawingView drawingView, double x, double y, double tolerance) {
        BezierPath path = (BezierPath)this.getOwner().get(this.bezierPathKey);
        if (path != null) {
            Point2D p = drawingView.viewToWorld(x, y);
            return path.contains(p.getX(), p.getY(), tolerance);
        }
        return false;
    }

    @Override
    public Node getNode(@NonNull DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.path1.setStroke((Paint)Color.WHITE);
        this.path2.setStroke(Paintable.getPaint(color));
        this.strokeWidth = view.getEditor().getHandleStrokeWidth();
        this.path1.setStrokeWidth(this.strokeWidth + 2.0);
        this.path2.setStrokeWidth(this.strokeWidth);
        return this.node;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.getOwner();
        BezierPath path = (BezierPath)f.get(this.bezierPathKey);
        if (path == null) {
            this.path1.getElements().clear();
            this.path2.getElements().clear();
            return;
        }
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        ArrayList<Object> elements = new ArrayList<Object>();
        FXPathElementsBuilder builder = new FXPathElementsBuilder(elements);
        AwtShapes.buildFromPathIterator((PathBuilder)builder, (PathIterator)path.getPathIterator(FXShapes.awtTransformFromFX((Transform)t)));
        double arrowLength = 4.0 * Math.max(2.0, this.strokeWidth);
        double arrowWidth = 1.5 * Math.max(2.0, this.strokeWidth);
        if (!elements.isEmpty()) {
            double x = 0.0;
            double y = 0.0;
            double newx = 0.0;
            double newy = 0.0;
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                PathElement pathElement;
                PathElement node = (PathElement)elements.get(i);
                Point2D p = null;
                Point2D dir = null;
                Objects.requireNonNull(node);
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LineTo.class, QuadCurveTo.class, CubicCurveTo.class, MoveTo.class}, (Object)pathElement, n2)) {
                    case 0: {
                        LineTo e = (LineTo)pathElement;
                        newx = e.getX();
                        newy = e.getY();
                        p = FXLines.lerp((double)x, (double)y, (double)e.getX(), (double)e.getY(), (double)0.5);
                        dir = new Point2D(e.getX() - x, e.getY() - y).normalize();
                        break;
                    }
                    case 1: {
                        QuadCurveTo e = (QuadCurveTo)pathElement;
                        PointAndDerivative pAndD = QuadCurves.eval((double)x, (double)y, (double)e.getControlX(), (double)e.getControlY(), (double)e.getX(), (double)e.getY(), (double)0.5);
                        p = (Point2D)pAndD.getPoint(Point2D::new);
                        dir = ((Point2D)pAndD.getDerivative(Point2D::new)).normalize();
                        newx = e.getX();
                        newy = e.getY();
                        break;
                    }
                    case 2: {
                        CubicCurveTo e = (CubicCurveTo)pathElement;
                        PointAndDerivative pAndD = CubicCurves.eval((double)x, (double)y, (double)e.getControlX1(), (double)e.getControlY1(), (double)e.getControlX2(), (double)e.getControlY2(), (double)e.getX(), (double)e.getY(), (double)0.5);
                        p = (Point2D)pAndD.getPoint(Point2D::new);
                        dir = ((Point2D)pAndD.getDerivative(Point2D::new)).normalize();
                        newx = e.getX();
                        newy = e.getY();
                        break;
                    }
                    case 3: {
                        MoveTo e = (MoveTo)pathElement;
                        newx = e.getX();
                        newy = e.getY();
                        break;
                    }
                }
                if (p != null && dir != null) {
                    Point2D perp = FXGeom.perp(dir);
                    double vx = perp.getX() * arrowWidth;
                    double vy = perp.getY() * arrowWidth;
                    double dx = dir.getX() * arrowLength;
                    double dy = dir.getY() * arrowLength;
                    elements.add(new MoveTo(p.getX() - vx - dx, p.getY() - vy - dy));
                    elements.add(new LineTo(p.getX(), p.getY()));
                    elements.add(new LineTo(p.getX() + vx - dx, p.getY() + vy - dy));
                }
                x = newx;
                y = newy;
            }
        }
        this.path1.getElements().setAll(elements);
        this.path2.getElements().setAll(elements);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public boolean isEditable() {
        return false;
    }
}

