/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.FXTransforms;

public class BoundsInLocalOutlineHandle
extends AbstractHandle {
    private final Group node = new Group();
    private final Polygon poly1;
    private final Polygon poly2;
    private final double[] points = new double[8];

    public BoundsInLocalOutlineHandle(Figure figure) {
        super(figure);
        this.poly1 = new Polygon(this.points);
        this.poly2 = new Polygon(this.points);
        this.poly1.setStrokeLineCap(StrokeLineCap.BUTT);
        this.poly2.setStrokeLineCap(StrokeLineCap.BUTT);
        this.poly1.setFill(null);
        this.poly2.setFill(null);
        this.node.getChildren().addAll((Object[])new Node[]{this.poly1, this.poly2});
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(@NonNull DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.poly1.setStroke((Paint)Color.WHITE);
        this.poly2.setStroke(Paintable.getPaint(color));
        double strokeWidth = view.getEditor().getHandleStrokeWidth();
        this.poly1.setStrokeWidth(strokeWidth + 2.0);
        this.poly2.setStrokeWidth(strokeWidth);
        return this.node;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        t = FXTransforms.concat((Transform[])new Transform[]{Transform.translate((double)0.5, (double)0.5), t});
        Bounds b = f.getLayoutBounds();
        this.points[0] = b.getMinX();
        this.points[1] = b.getMinY();
        this.points[2] = b.getMaxX();
        this.points[3] = b.getMinY();
        this.points[4] = b.getMaxX();
        this.points[5] = b.getMaxY();
        this.points[6] = b.getMinX();
        this.points[7] = b.getMaxY();
        FXTransforms.transform2DPoints((Transform)t, (double[])this.points, (int)0, (double[])this.points, (int)0, (int)4);
        ObservableList pp1 = this.poly1.getPoints();
        ObservableList pp2 = this.poly2.getPoints();
        for (int i = 0; i < this.points.length; ++i) {
            pp1.set(i, (Object)this.points[i]);
            pp2.set(i, (Object)this.points[i]);
        }
    }
}

