/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.FXTransforms;

public class BoundsInParentOutlineHandle
extends AbstractHandle {
    private final Polygon node;
    private final double[] points = new double[8];

    public BoundsInParentOutlineHandle(Figure figure) {
        super(figure);
        this.node = new Polygon(this.points);
        this.initNode(this.node);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(@NonNull DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        Color color1 = (Color)Paintable.getPaint(color);
        this.node.setStroke((Paint)color1);
        return this.node;
    }

    protected void initNode(@NonNull Polygon r) {
        r.setFill(null);
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getParentToWorld()});
        Bounds b = f.getLayoutBoundsInParent();
        this.points[0] = b.getMinX();
        this.points[1] = b.getMinY();
        this.points[2] = b.getMaxX();
        this.points[3] = b.getMinY();
        this.points[4] = b.getMaxX();
        this.points[5] = b.getMaxY();
        this.points[6] = b.getMinX();
        this.points[7] = b.getMaxY();
        FXTransforms.transform2DPoints((Transform)t, (double[])this.points, (int)0, (double[])this.points, (int)0, (int)4);
        ObservableList pp = this.node.getPoints();
        for (int i = 0; i < this.points.length; ++i) {
            pp.set(i, (Object)this.points[i]);
        }
    }
}

