/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.HashSet;
import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;

public class RotateHandle
extends AbstractHandle {
    public static final @Nullable BorderStrokeStyle INSIDE_STROKE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 1.0, 0.0, null);
    private static final @Nullable Background HANDLE_REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final @Nullable Border HANDLE_REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.PURPLE, BorderStrokeStyle.SOLID, null, null)});
    private static final Circle PICK_NODE_SHAPE = new Circle(3.0);
    private static final SVGPath PIVOT_NODE_SHAPE = new SVGPath();
    private static final @Nullable Background PIVOT_REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.PURPLE, null, null)});
    private static final @Nullable Border PIVOT_REGION_BORDER = null;
    private final @NonNull Group group = new Group();
    private Set<Figure> groupReshapeableFigures;
    private final @NonNull Line line;
    private double lineLength = 10.0;
    private Point2D pickLocation;
    private final @NonNull Region pickNode = new Region();
    private final @NonNull Region pivotNode;

    public RotateHandle(TransformableFigure figure) {
        super(figure);
        this.pickNode.setShape((Shape)PICK_NODE_SHAPE);
        this.pickNode.setManaged(false);
        this.pickNode.setScaleShape(true);
        this.pickNode.setCenterShape(true);
        this.pickNode.resize(11.0, 11.0);
        this.pickNode.getStyleClass().clear();
        this.pickNode.setBorder(HANDLE_REGION_BORDER);
        this.pickNode.setBackground(HANDLE_REGION_BACKGROUND);
        this.pivotNode = new Region();
        this.pivotNode.setShape((Shape)PIVOT_NODE_SHAPE);
        this.pivotNode.setManaged(false);
        this.pivotNode.setScaleShape(true);
        this.pivotNode.setCenterShape(true);
        this.pivotNode.resize(11.0, 11.0);
        this.pivotNode.getStyleClass().clear();
        this.pivotNode.setBorder(PIVOT_REGION_BORDER);
        this.pivotNode.setBackground(PIVOT_REGION_BACKGROUND);
        this.pivotNode.setVisible(false);
        this.line = new Line();
        this.line.getStyleClass().clear();
        this.group.getChildren().addAll((Object[])new Node[]{this.line, this.pickNode, this.pivotNode});
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.CROSSHAIR;
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public @NonNull Group getNode(@NonNull DrawingView view) {
        double size = view.getEditor().getHandleSize();
        this.lineLength = size * 1.5;
        if (this.pickNode.getWidth() != size) {
            this.pickNode.resize(size, size);
        }
        Paint color = Paintable.getPaint(view.getEditor().getHandleColor());
        this.line.setStroke(color);
        BorderStroke borderStroke = (BorderStroke)this.pickNode.getBorder().getStrokes().getFirst();
        if (borderStroke == null || !borderStroke.getTopStroke().equals(color)) {
            Border border = new Border(new BorderStroke[]{new BorderStroke(color, INSIDE_STROKE, null, null)});
            this.pickNode.setBorder(border);
            this.pivotNode.setBorder(border);
        }
        return this.group;
    }

    @Override
    public @NonNull TransformableFigure getOwner() {
        return (TransformableFigure)super.getOwner();
    }

    private @Nullable Transform getRotateToWorld() {
        TransformableFigure o = this.getOwner();
        Transform t = o.getParentToWorld();
        Point2D center = FXRectangles.center((Bounds)o.getLayoutBounds());
        Translate translate = Transform.translate((double)((Double)o.getStyled((MapAccessor)TransformableFigure.TRANSLATE_X)), (double)((Double)o.getStyled((MapAccessor)TransformableFigure.TRANSLATE_Y)));
        Scale scale = Transform.scale((double)((Double)o.getStyled((MapAccessor)TransformableFigure.SCALE_X)), (double)((Double)o.getStyled((MapAccessor)TransformableFigure.SCALE_Y)), (double)center.getX(), (double)center.getY());
        Rotate rotate = Transform.rotate((double)((Double)o.getStyled((MapAccessor)TransformableFigure.ROTATE)), (double)center.getX(), (double)center.getY());
        t = FXTransforms.concat((Transform[])new Transform[]{t, FXTransforms.concat((Transform[])new Transform[]{translate, rotate})});
        return t;
    }

    private @Nullable Transform getWorldToRotate() {
        TransformableFigure o = this.getOwner();
        Transform t = o.getWorldToParent();
        Point2D center = FXRectangles.center((Bounds)o.getLayoutBounds());
        Translate translate = Transform.translate((double)(-((Double)o.getStyled((MapAccessor)TransformableFigure.TRANSLATE_X)).doubleValue()), (double)(-((Double)o.getStyled((MapAccessor)TransformableFigure.TRANSLATE_Y)).doubleValue()));
        Scale scale = Transform.scale((double)(1.0 / (Double)o.getStyled((MapAccessor)TransformableFigure.SCALE_X)), (double)(1.0 / (Double)o.getStyled((MapAccessor)TransformableFigure.SCALE_Y)), (double)center.getX(), (double)center.getY());
        Rotate rotate = Transform.rotate((double)(-((Double)o.getStyled((MapAccessor)TransformableFigure.ROTATE)).doubleValue()), (double)center.getX(), (double)center.getY());
        t = FXTransforms.concat((Transform[])new Transform[]{t, translate});
        return t;
    }

    @Override
    public void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        TransformableFigure o = this.getOwner();
        Point2D center = FXRectangles.center((Bounds)o.getLayoutBounds());
        Transform t = FXTransforms.concat((Transform[])new Transform[]{this.getWorldToRotate(), view.getViewToWorld()});
        Point2D newPoint = FXTransforms.transform((Transform)t, (Point2D)new Point2D(event.getX(), event.getY()));
        double newRotate = 90.0 + Math.toDegrees(Angles.angle((double)center.getX(), (double)center.getY(), (double)newPoint.getX(), (double)newPoint.getY()));
        if ((newRotate %= 360.0) < 0.0) {
            newRotate += 360.0;
        }
        if (!event.isAltDown() && !event.isControlDown()) {
            newRotate = view.getConstrainer().constrainAngle(this.getOwner(), newRotate);
        }
        if (event.isMetaDown()) {
            // empty if block
        }
        DrawingModel model = view.getModel();
        if (event.isShiftDown()) {
            for (Figure f : this.groupReshapeableFigures) {
                if (!(f instanceof TransformableFigure)) continue;
                model.set(f, TransformableFigure.ROTATE, newRotate);
            }
        } else {
            model.set(this.getOwner(), TransformableFigure.ROTATE, newRotate);
        }
    }

    @Override
    public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.pivotNode.setVisible(true);
        ObservableSet<Figure> selectedFigures = view.getSelectedFigures();
        this.groupReshapeableFigures = new HashSet<Figure>();
        for (Figure f : view.getSelectedFigures()) {
            if (!f.isGroupReshapeableWith((Set<Figure>)selectedFigures)) continue;
            this.groupReshapeableFigures.add(f);
        }
        this.groupReshapeableFigures = view.getFiguresWithCompatibleHandle(this.groupReshapeableFigures, this);
    }

    @Override
    public void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        this.pivotNode.setVisible(false);
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        TransformableFigure o = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), this.getRotateToWorld()});
        Bounds b = o.getLayoutBounds();
        Point2D centerInLocal = FXRectangles.center((Bounds)b);
        double scaleY = (Double)o.getStyled((MapAccessor)TransformableFigure.SCALE_Y);
        Point2D p = new Point2D(centerInLocal.getX(), centerInLocal.getY() - b.getHeight() * 0.5 * scaleY);
        p = FXTransforms.transform((Transform)t, (Point2D)p);
        double rotate = (Double)o.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE);
        this.pickNode.setRotate(rotate);
        Point3D rotationAxis = (Point3D)o.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS);
        this.pickNode.setRotationAxis(rotationAxis);
        this.pivotNode.setRotate(rotate);
        this.pivotNode.setRotationAxis(rotationAxis);
        Point2D centerInView = FXTransforms.transform((Transform)t, (Point2D)centerInLocal);
        Point2D vector = new Point2D(p.getX() - centerInView.getX(), p.getY() - centerInView.getY());
        double size = this.pickNode.getWidth();
        vector = vector.normalize();
        this.pickLocation = new Point2D(p.getX() + vector.getX() * this.lineLength, p.getY() + vector.getY() * this.lineLength);
        this.pickNode.relocate(this.pickLocation.getX() - size * 0.5, this.pickLocation.getY() - size * 0.5);
        this.pivotNode.relocate(centerInView.getX() - size * 0.5, centerInView.getY() - size * 0.5);
        this.line.setStartX(this.pickLocation.getX());
        this.line.setStartY(this.pickLocation.getY());
        this.line.setEndX(p.getX());
        this.line.setEndY(p.getY());
    }

    static {
        PIVOT_NODE_SHAPE.setContent("M-5,-1 L -1,-1 -1,-5 1,-5 1,-1 5,-1 5 1 1,1 1,5 -1,5 -1,1 -5,1 Z");
    }
}

