/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.Collection;
import java.util.function.Function;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractResizeTransformHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class TransformHandleKit {
    protected static final SVGPath NORTH_SHAPE = new SVGPath();
    protected static final SVGPath EAST_SHAPE = new SVGPath();
    protected static final SVGPath WEST_SHAPE = new SVGPath();
    protected static final SVGPath SOUTH_SHAPE = new SVGPath();
    protected static final SVGPath NORTH_EAST_SHAPE = new SVGPath();
    protected static final SVGPath NORTH_WEST_SHAPE = new SVGPath();
    protected static final SVGPath SOUTH_EAST_SHAPE = new SVGPath();
    protected static final SVGPath SOUTH_WEST_SHAPE = new SVGPath();
    private static final @NonNull Background REGION_BACKGROUND;
    private static final @NonNull Function<Color, Border> REGION_BORDER;

    private TransformHandleKit() {
    }

    public static void addCornerTransformHandles(TransformableFigure f, @NonNull Collection<Handle> handles) {
        handles.add(TransformHandleKit.southEast(f));
        handles.add(TransformHandleKit.southWest(f));
        handles.add(TransformHandleKit.northEast(f));
        handles.add(TransformHandleKit.northWest(f));
    }

    public static void addEdgeTransformHandles(TransformableFigure f, @NonNull Collection<Handle> handles) {
        handles.add(TransformHandleKit.south(f));
        handles.add(TransformHandleKit.north(f));
        handles.add(TransformHandleKit.east(f));
        handles.add(TransformHandleKit.west(f));
    }

    public static void addTransformHandles(TransformableFigure f, @NonNull Collection<Handle> handles) {
        TransformHandleKit.addCornerTransformHandles(f, handles);
        TransformHandleKit.addEdgeTransformHandles(f, handles);
    }

    public static @NonNull Handle south(TransformableFigure owner) {
        return new SouthHandle(owner);
    }

    public static @NonNull Handle southEast(TransformableFigure owner) {
        return new SouthEastHandle(owner);
    }

    public static @NonNull Handle southWest(TransformableFigure owner) {
        return new SouthWestHandle(owner);
    }

    public static @NonNull Handle north(TransformableFigure owner) {
        return new NorthHandle(owner);
    }

    public static @NonNull Handle northEast(TransformableFigure owner) {
        return new NorthEastHandle(owner);
    }

    public static @NonNull Handle northWest(TransformableFigure owner) {
        return new NorthWestHandle(owner);
    }

    public static @NonNull Handle east(TransformableFigure owner) {
        return new EastHandle(owner);
    }

    public static @NonNull Handle west(TransformableFigure owner) {
        return new WestHandle(owner);
    }

    static {
        String circle = "M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z ";
        NORTH_EAST_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 4.5,9 4.5,4.5 0,4.5 ");
        NORTH_WEST_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 9,4.5 4.5,4.5 4.5,9");
        SOUTH_EAST_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 0,4.5 4.5,4.5 4.5,0");
        SOUTH_WEST_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 4.5,0 4.5,4.5 9,4.5 ");
        SOUTH_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 0,4.5 9,4.5");
        NORTH_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 0,4.5 9,4.5");
        EAST_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 4.5,0 4.5,9");
        WEST_SHAPE.setContent("M 9,4.5 A 4.5,4.5 0 1 0 0,4.5 A 4.5,4.5 0 1 0 9,4.5 Z M 4.5,0 4.5,9");
        REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
        REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    }

    private static class SouthHandle
    extends AbstractTransformHandle {
        SouthHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.SOUTH, (Shape)SOUTH_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.S_RESIZE;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newY = Math.max(bounds.getMinY(), newPoint.getY());
            double newWidth = bounds.getMaxX() - bounds.getMinX();
            double newHeight = newY - bounds.getMinY();
            if (keepAspect) {
                newWidth = newHeight / this.preferredAspectRatio;
            }
            this.transform(model, owner, (bounds.getMinX() + bounds.getMaxX() - newWidth) * 0.5, bounds.getMinY(), newWidth, newHeight);
        }
    }

    private static class SouthEastHandle
    extends AbstractTransformHandle {
        SouthEastHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.SOUTH_EAST, (Shape)SOUTH_EAST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.SE_RESIZE;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newX = Math.max(bounds.getMinX(), newPoint.getX());
            double newY = Math.max(bounds.getMinY(), newPoint.getY());
            double newWidth = newX - bounds.getMinX();
            double newHeight = newY - bounds.getMinY();
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth * this.preferredAspectRatio;
                } else {
                    newWidth = newHeight / this.preferredAspectRatio;
                }
            }
            this.transform(model, owner, bounds.getMinX(), bounds.getMinY(), newWidth, newHeight);
        }
    }

    private static class SouthWestHandle
    extends AbstractTransformHandle {
        SouthWestHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.SOUTH_WEST, (Shape)SOUTH_WEST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.CROSSHAIR;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newX = Math.min(bounds.getMaxX(), newPoint.getX());
            double newY = Math.max(bounds.getMinY(), newPoint.getY());
            double newWidth = bounds.getMaxX() - Math.min(bounds.getMaxX(), newX);
            double newHeight = newY - bounds.getMinY();
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth * this.preferredAspectRatio;
                } else {
                    newWidth = newHeight / this.preferredAspectRatio;
                }
            }
            this.transform(model, owner, bounds.getMaxX() - newWidth, bounds.getMinY(), newWidth, newHeight);
        }
    }

    private static class NorthHandle
    extends AbstractTransformHandle {
        NorthHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.NORTH, (Shape)NORTH_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.CROSSHAIR;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newY = Math.min(bounds.getMaxY(), newPoint.getY());
            double newWidth = bounds.getMaxX() - bounds.getMinX();
            double newHeight = bounds.getMaxY() - newY;
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                newWidth = newHeight / this.preferredAspectRatio;
            }
            this.transform(model, owner, (bounds.getMinX() + bounds.getMaxX() - newWidth) * 0.5, newY, newWidth, newHeight);
        }
    }

    private static class NorthEastHandle
    extends AbstractTransformHandle {
        NorthEastHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.NORTH_EAST, (Shape)NORTH_EAST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.CROSSHAIR;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newX = Math.max(bounds.getMinX(), newPoint.getX());
            double newY = Math.min(bounds.getMaxY(), newPoint.getY());
            double newWidth = newX - bounds.getMinX();
            double newHeight = bounds.getMaxY() - newY;
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth * this.preferredAspectRatio;
                } else {
                    newWidth = newHeight / this.preferredAspectRatio;
                }
            }
            this.transform(model, owner, bounds.getMinX(), bounds.getMaxY() - newHeight, newWidth, newHeight);
        }
    }

    private static class NorthWestHandle
    extends AbstractTransformHandle {
        NorthWestHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.NORTH_WEST, (Shape)NORTH_WEST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.CROSSHAIR;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newX = Math.min(bounds.getMaxX(), newPoint.getX());
            double newY = Math.min(bounds.getMaxY(), newPoint.getY());
            double newWidth = bounds.getMaxX() - newX;
            double newHeight = bounds.getMaxY() - newY;
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth * this.preferredAspectRatio;
                } else {
                    newWidth = newHeight / this.preferredAspectRatio;
                }
            }
            this.transform(model, owner, bounds.getMaxX() - newWidth, bounds.getMaxY() - newHeight, newWidth, newHeight);
        }
    }

    private static class EastHandle
    extends AbstractTransformHandle {
        EastHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.EAST, (Shape)EAST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.CROSSHAIR;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newWidth = Math.max(newPoint.getX(), bounds.getMinX()) - bounds.getMinX();
            double newHeight = bounds.getMaxY() - bounds.getMinY();
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                newHeight = newWidth * this.preferredAspectRatio;
            }
            this.transform(model, owner, bounds.getMinX(), (bounds.getMinY() + bounds.getMaxY() - newHeight) * 0.5, newWidth, newHeight);
        }
    }

    private static class WestHandle
    extends AbstractTransformHandle {
        WestHandle(TransformableFigure owner) {
            super(owner, BoundsLocator.WEST, (Shape)WEST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.CROSSHAIR;
        }

        @Override
        protected void resize(@NonNull Point2D newPoint, Figure owner, @NonNull Bounds bounds, @NonNull DrawingModel model, boolean keepAspect) {
            double newX = Math.min(bounds.getMaxX(), newPoint.getX());
            double newWidth = bounds.getMaxX() - newX;
            double newHeight = bounds.getHeight();
            if (keepAspect) {
                double newRatio = newHeight / newWidth;
                newHeight = newWidth * this.preferredAspectRatio;
            }
            this.transform(model, owner, newX, (bounds.getMinY() + bounds.getMaxY() - newHeight) * 0.5, newWidth, newHeight);
        }
    }

    private static abstract class AbstractTransformHandle
    extends AbstractResizeTransformHandle {
        @Nullable ImmutableList<Transform> startTransforms;

        public AbstractTransformHandle(Figure owner, Locator locator, Shape shape, Background bg, Function<Color, Border> border) {
            super(owner, locator, shape, bg, border);
        }

        @Override
        public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
            super.onMousePressed(event, view);
            this.startTransforms = (ImmutableList)this.owner.get((MapAccessor)TransformableFigure.TRANSFORMS);
        }

        protected void transform(@NonNull DrawingModel model, Figure o, double x, double y, double width, double height) {
            if (width == 0.0 || height == 0.0) {
                return;
            }
            TransformableFigure owner = (TransformableFigure)o;
            Bounds oldBounds = this.startBounds.getConvertedBoundsValue();
            ImmutableList<Transform> oldTransforms = this.startTransforms == null ? VectorList.of() : this.startTransforms;
            double sx = width / oldBounds.getWidth();
            double sy = height / oldBounds.getHeight();
            double tx = x - oldBounds.getMinX();
            double ty = y - oldBounds.getMinY();
            Translate transform = new Translate(tx, ty);
            if (!(Double.isNaN(sx) || Double.isNaN(sy) || Double.isInfinite(sx) || Double.isInfinite(sy) || sx == 1.0 && sy == 1.0)) {
                transform = FXTransforms.concat((Transform[])new Transform[]{transform, new Scale(sx, sy, oldBounds.getMinX(), oldBounds.getMinY())});
            }
            switch (oldTransforms.size()) {
                case 0: {
                    model.set(owner, TransformableFigure.TRANSFORMS, VectorList.of((Object[])new Transform[]{transform}));
                    break;
                }
                default: {
                    int last = oldTransforms.size() - 1;
                    model.set(owner, TransformableFigure.TRANSFORMS, oldTransforms.set(last, (Object)FXTransforms.concat((Transform[])new Transform[]{(Transform)oldTransforms.get(last), transform})));
                }
            }
        }

        @Override
        protected void resize(@NonNull CssPoint2D newPoint, Figure owner, @NonNull CssRectangle2D bounds, @NonNull DrawingModel model, boolean keepAspect) {
            this.resize(newPoint.getConvertedValue(), owner, bounds.getConvertedBoundsValue(), model, keepAspect);
        }
    }
}

