/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.prefs.Preferences;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.NumberConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.constrain.GridConstrainer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.inspector.AbstractDrawingViewInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.converter.StringConverterAdapter;

public class GridInspector
extends AbstractDrawingViewInspector {
    @FXML
    private TextField angleField;
    @FXML
    private CheckBox drawGridCheckBox;
    private GridConstrainer gridConstrainer;
    @FXML
    private TextField heightField;
    @FXML
    private TextField gridColorField;
    @FXML
    private ColorPicker gridColorPicker;
    @FXML
    private TextField majorXField;
    @FXML
    private TextField majorYField;
    private final @NonNull Property<CssColor> gridColorProperty = new SimpleObjectProperty();
    private Node node;
    @FXML
    private CheckBox snapToGridCheckBox;
    @FXML
    private TextField widthField;
    @FXML
    private TextField xField;
    @FXML
    private TextField yField;

    public GridInspector() {
        this(GridInspector.class.getResource("GridInspector.fxml"));
    }

    public GridInspector(@NonNull URL fxmlUrl) {
        this.init(fxmlUrl);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void init(@NonNull URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
        });
        Preferences prefs = Preferences.userNodeForPackage(GridInspector.class);
        this.snapToGridCheckBox.setSelected(prefs.getBoolean("snapToGrid", true));
        this.snapToGridCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> prefs.putBoolean("snapToGrid", (boolean)newValue));
        this.drawGridCheckBox.setSelected(prefs.getBoolean("drawGrid", true));
        this.drawGridCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> prefs.putBoolean("drawGrid", (boolean)newValue));
        CustomBinding.bindBidirectionalAndConvert(this.gridColorProperty, (WritableValue)this.gridColorPicker.valueProperty(), c -> c == null ? null : c.getColor(), CssColor::new);
        this.gridColorField.textProperty().bindBidirectional(this.gridColorProperty, (StringConverter)new StringConverterAdapter((Converter)new ColorCssConverter(false)));
    }

    @Override
    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        Preferences prefs = Preferences.userNodeForPackage(GridInspector.class);
        ChangeListener prefsGridX = (o, oldv, newv) -> {
            prefs.putDouble("gridX", newv.getValue());
            String units = newv.getUnits();
            prefs.put("gridXUnits", units);
        };
        ChangeListener prefsGridY = (o, oldv, newv) -> {
            prefs.putDouble("gridY", newv.getValue());
            String units = newv.getUnits();
            prefs.put("gridYUnits", units);
        };
        ChangeListener prefsGridWidth = (o, oldv, newv) -> {
            prefs.putDouble("gridWidth", newv.getValue());
            String units = newv.getUnits();
            prefs.put("gridWidthUnits", units);
        };
        ChangeListener prefsGridHeight = (o, oldv, newv) -> {
            prefs.putDouble("gridHeight", newv.getValue());
            String units = newv.getUnits();
            prefs.put("gridHeightUnits", units);
        };
        ChangeListener prefsGridAngle = (o, oldv, newv) -> prefs.putDouble("gridAngle", newv.doubleValue());
        ChangeListener prefsGridMajorX = (o, oldv, newv) -> prefs.putInt("gridMajorX", newv.intValue());
        ChangeListener prefsGridMajorY = (o, oldv, newv) -> prefs.putInt("gridMajorY", newv.intValue());
        ChangeListener prefsGridColor = (o, oldv, newv) -> prefs.put("gridColor", newv.getName());
        if (oldValue != null) {
            this.heightField.textProperty().unbind();
            this.widthField.textProperty().unbind();
            this.xField.textProperty().unbind();
            this.yField.textProperty().unbind();
            this.majorXField.textProperty().unbind();
            this.majorYField.textProperty().unbind();
            this.angleField.textProperty().unbind();
            this.drawGridCheckBox.selectedProperty().unbind();
            this.snapToGridCheckBox.selectedProperty().unbind();
            if (oldValue instanceof GridConstrainer) {
                GridConstrainer gc = (GridConstrainer)((Object)oldValue);
                this.gridColorProperty.unbindBidirectional(gc.gridColorProperty());
            }
        }
        if (newValue != null) {
            this.gridConstrainer = new GridConstrainer(CssSize.of((double)prefs.getDouble("gridX", 0.0), (String)prefs.get("gridXUnits", null)), CssSize.of((double)prefs.getDouble("gridY", 0.0), (String)prefs.get("gridYUnits", null)), CssSize.of((double)prefs.getDouble("gridWidth", 0.0), (String)prefs.get("gridWidthUnits", null)), CssSize.of((double)prefs.getDouble("gridHeight", 0.0), (String)prefs.get("gridHeightUnits", null)), prefs.getDouble("gridAngle", 11.25), prefs.getInt("gridMajorX", 5), prefs.getInt("gridMajorY", 5));
            ColorCssConverter converter = new ColorCssConverter(true);
            try {
                this.gridConstrainer.setGridColor((CssColor)converter.fromString(prefs.get("gridColor", this.gridConstrainer.getGridColor().getName())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            newValue.setConstrainer(this.gridConstrainer);
            StringConverterAdapter sc = new StringConverterAdapter((Converter)new SizeCssConverter(false));
            StringConverterAdapter nc = new StringConverterAdapter((Converter)new NumberConverter());
            this.heightField.textProperty().bindBidirectional(this.gridConstrainer.heightProperty(), (StringConverter)sc);
            this.widthField.textProperty().bindBidirectional(this.gridConstrainer.widthProperty(), (StringConverter)sc);
            this.xField.textProperty().bindBidirectional(this.gridConstrainer.xProperty(), (StringConverter)sc);
            this.yField.textProperty().bindBidirectional(this.gridConstrainer.yProperty(), (StringConverter)sc);
            this.majorXField.textProperty().bindBidirectional((Property)this.gridConstrainer.majorXProperty(), (StringConverter)nc);
            this.majorYField.textProperty().bindBidirectional((Property)this.gridConstrainer.majorYProperty(), (StringConverter)nc);
            this.angleField.textProperty().bindBidirectional((Property)this.gridConstrainer.angleProperty(), (StringConverter)nc);
            this.gridConstrainer.drawGridProperty().set(this.drawGridCheckBox.isSelected());
            this.drawGridCheckBox.selectedProperty().bindBidirectional((Property)this.gridConstrainer.drawGridProperty());
            this.gridConstrainer.snapToGridProperty().set(this.snapToGridCheckBox.isSelected());
            this.snapToGridCheckBox.selectedProperty().bindBidirectional((Property)this.gridConstrainer.snapToGridProperty());
            if (this.gridConstrainer != null) {
                this.gridConstrainer.xProperty().addListener(prefsGridX);
                this.gridConstrainer.yProperty().addListener(prefsGridY);
                this.gridConstrainer.widthProperty().addListener(prefsGridWidth);
                this.gridConstrainer.heightProperty().addListener(prefsGridHeight);
                this.gridConstrainer.angleProperty().addListener(prefsGridAngle);
                this.gridConstrainer.majorXProperty().addListener(prefsGridMajorX);
                this.gridConstrainer.majorYProperty().addListener(prefsGridMajorY);
                this.gridConstrainer.gridColorProperty().addListener(prefsGridColor);
                this.gridColorProperty.bindBidirectional(this.gridConstrainer.gridColorProperty());
            }
        }
    }
}

