/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.inspector.AbstractDrawingInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.inspector.LayerCell;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelFigureChildrenObservableList;
import org.jhotdraw8.fxbase.clipboard.ClipboardIO;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.control.ListViewUtil;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jhotdraw8.fxcollection.ReversedObservableList;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class LayersInspector
extends AbstractDrawingInspector {
    @FXML
    private ListView<Figure> listView;
    @FXML
    private Button addButton;
    @FXML
    private Button removeButton;
    private @Nullable ReversedObservableList<Figure> layers;
    private final Supplier<Layer> layerFactory;
    private Node node;
    private final @NonNull HashMap<Layer, Integer> selectionCount = new HashMap();
    private final @Nullable ChangeListener<Figure> selectedLayerHandler = new ChangeListener<Figure>(){
        int changedRecursion = 0;

        public void changed(ObservableValue<? extends Figure> observable, Figure oldValue, @Nullable Figure newValue) {
            if (this.changedRecursion++ == 0 && newValue != null) {
                LayersInspector.this.listView.getSelectionModel().select((Object)newValue);
            }
            --this.changedRecursion;
        }
    };
    private final @Nullable Listener<TreeModelEvent<Figure>> listInvalidationListener = event -> {
        boolean fire = false;
        Figure root = (Figure)((TreeModel)event.getSource()).getRoot();
        switch (event.getEventType()) {
            case ROOT_CHANGED: {
                fire = true;
                break;
            }
            case SUBTREE_NODES_CHANGED: {
                if (event.getNode() != root) break;
                fire = true;
                break;
            }
            case NODE_ADDED_TO_PARENT: 
            case NODE_REMOVED_FROM_PARENT: {
                if (event.getParent() != root) break;
                fire = true;
                break;
            }
        }
        if (fire) {
            this.getModel().fireNodeInvalidated(this.getDrawing());
        }
    };
    private final @NonNull InvalidationListener selectionInvalidationListener = observable -> this.onSelectionChanged();
    private boolean isUpdateSelection;

    public LayersInspector() {
        this(LayersInspector.class.getResource("LayersInspector.fxml"));
    }

    public LayersInspector(@NonNull URL fxmlUrl) {
        this(fxmlUrl, LayerFigure::new);
    }

    public LayersInspector(@NonNull URL fxmlUrl, Supplier<Layer> layerFactory) {
        this.layerFactory = layerFactory;
        this.init(fxmlUrl);
    }

    public LayersInspector(Supplier<Layer> layerFactory) {
        this(LayersInspector.getResourceNonNull("LayersInspector.fxml"), layerFactory);
    }

    private static URL getResourceNonNull(String s) {
        URL resource = LayersInspector.class.getResource(s);
        if (resource == null) {
            throw new RuntimeException("Could not load resource=" + s);
        }
        return resource;
    }

    private void onSelectionChanged() {
        if (!this.isUpdateSelection) {
            this.isUpdateSelection = true;
            Platform.runLater(this::updateSelection);
        }
    }

    private void updateSelection() {
        this.isUpdateSelection = false;
        Drawing d = this.getDrawing();
        ObservableSet<Figure> selection = ((DrawingView)this.getSubject()).getSelectedFigures();
        HashMap<Figure, Integer> layerToIndex = new HashMap<Figure, Integer>();
        ObservableList<Figure> children = d.getChildren();
        int[] count = new int[children.size()];
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            layerToIndex.put((Figure)children.get(i), i);
        }
        for (Figure f : selection) {
            Layer l = f.getLayer();
            Integer index = (Integer)layerToIndex.get(l);
            if (index == null) continue;
            int n2 = index;
            count[n2] = count[n2] + 1;
        }
        n = children.size();
        for (int i = 0; i < n; ++i) {
            this.selectionCount.put((Layer)children.get(i), count[i]);
        }
        if (this.layers != null) {
            this.layers.fireUpdated(0, this.layers.size());
        }
    }

    private void init(@NonNull URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
            this.addButton.addEventHandler(ActionEvent.ACTION, event -> {
                Layer layer = this.layerFactory.get();
                int index = this.listView.getSelectionModel().getSelectedIndex();
                if (index < 0) {
                    index = 0;
                }
                Drawing drawing = this.getDrawing();
                DrawingModel model = this.getModel();
                int size = drawing.getChildren().size();
                model.insertChildAt(layer, drawing, size - index);
            });
            this.removeButton.addEventHandler(ActionEvent.ACTION, event -> {
                ArrayList indices = new ArrayList(this.listView.getSelectionModel().getSelectedIndices());
                Drawing drawing = this.getDrawing();
                DrawingModel model = this.getModel();
                for (int i = indices.size() - 1; i >= 0; --i) {
                    model.removeFromParent((Figure)this.layers.get(((Integer)indices.get(i)).intValue()));
                }
            });
            this.removeButton.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.listView.getSelectionModel().selectedIndexProperty(), (int)-1));
            this.listView.getSelectionModel().getSelectedItems().addListener(c -> {
                Layer selected = (Layer)this.listView.getSelectionModel().getSelectedItem();
                DrawingView subject = (DrawingView)this.getSubject();
                if (selected != null && subject != null) {
                    subject.setActiveParent(selected);
                }
            });
            ClipboardIO<Figure> io = new ClipboardIO<Figure>(){

                public void write(@NonNull Clipboard clipboard, @NonNull List<Figure> items) {
                    if (items.size() != 1) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    ClipboardContent content = new ClipboardContent();
                    Figure f = items.getFirst();
                    String id = (String)f.get((MapAccessor)StyleableFigure.ID);
                    content.putString(id == null ? "" : id);
                    clipboard.setContent((Map)content);
                }

                public @Nullable List<Figure> read(@NonNull Clipboard clipboard) {
                    ArrayList<Figure> list;
                    if (clipboard.hasString()) {
                        list = new ArrayList<Figure>();
                        Layer layer = LayersInspector.this.layerFactory.get();
                        layer.set((MapAccessor)StyleableFigure.ID, clipboard.getString());
                        list.add(layer);
                    } else {
                        list = null;
                    }
                    return list;
                }

                public boolean canRead(@NonNull Clipboard clipboard) {
                    return clipboard.hasString();
                }
            };
            this.listView.setFixedCellSize(24.0);
            this.listView.setCellFactory(this.addSelectionLabelDndSupport(this.listView, (Callback<ListView<Figure>, LayerCell>)((Callback)this::createCell), io));
            ListViewUtil.addReorderingSupport(this.listView, this::forwardUndoableEditEvent);
        });
    }

    public @NonNull LayerCell createCell(ListView<Figure> listView) {
        return new LayerCell(this.getModel(), this);
    }

    @Override
    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        super.onDrawingViewChanged(observable, oldValue, newValue);
        if (oldValue != null) {
            oldValue.activeParentProperty().removeListener(this.selectedLayerHandler);
            oldValue.selectedFiguresProperty().removeListener(this.selectionInvalidationListener);
        }
        if (newValue != null) {
            newValue.activeParentProperty().addListener(this.selectedLayerHandler);
            newValue.selectedFiguresProperty().addListener(this.selectionInvalidationListener);
        }
    }

    @Override
    protected void onDrawingChanged(@Nullable ObservableValue<? extends Drawing> observable, @Nullable Drawing oldValue, @Nullable Drawing newValue) {
        if (oldValue != null) {
            this.listView.setItems(FXCollections.observableArrayList());
            if (this.layers != null) {
                this.layers = null;
            }
        }
        if (newValue != null && newValue.getRoot() != null && this.drawingModel != null) {
            this.layers = new ReversedObservableList((ObservableList)new DrawingModelFigureChildrenObservableList(this.drawingModel, newValue));
            this.listView.setItems(this.layers);
        }
    }

    public ListView<Figure> getListView() {
        return this.listView;
    }

    @Override
    protected void onDrawingModelChanged(ObservableValue<? extends DrawingModel> observable, @Nullable DrawingModel oldValue, @Nullable DrawingModel newValue) {
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.listInvalidationListener);
        }
        if (newValue != null) {
            newValue.addTreeModelListener(this.listInvalidationListener);
        }
    }

    private @NonNull Callback<ListView<Figure>, ListCell<Figure>> addSelectionLabelDndSupport(@NonNull ListView<Figure> listView, @NonNull Callback<ListView<Figure>, LayerCell> cellFactory, ClipboardIO<Figure> clipboardIO) {
        SelectionLabelDnDSupport dndSupport = new SelectionLabelDnDSupport(listView, clipboardIO);
        Callback dndCellFactory = lv -> {
            LayerCell cell = (LayerCell)((Object)((Object)cellFactory.call(lv)));
            cell.getSelectionLabel().addEventHandler(MouseEvent.DRAG_DETECTED, dndSupport.cellMouseHandler);
            cell.addEventHandler(DragEvent.ANY, dndSupport.cellDragHandler);
            return cell;
        };
        return dndCellFactory;
    }

    int getSelectionCount(Layer item) {
        Integer value = this.selectionCount.get(item);
        return value == null ? 0 : value;
    }

    protected void moveSelectedFiguresFromToLayer(Layer from, @NonNull Layer to) {
        this.undoHelper.startCompositeEdit(null);
        DrawingModel model = this.getModel();
        DrawingView view = (DrawingView)this.getSubject();
        LinkedHashSet<Figure> selection = new LinkedHashSet<Figure>((Collection<Figure>)view.getSelectedFigures());
        for (Figure f : selection) {
            if (f instanceof Layer || f.getLayer() != from) continue;
            model.addChildTo(f, to);
        }
        view.getSelectedFigures().clear();
        view.getSelectedFigures().addAll(selection);
        this.undoHelper.stopCompositeEdit();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private class SelectionLabelDnDSupport {
        private final ListView<Figure> listView;
        private int draggedCellIndex;
        private final ClipboardIO<Figure> io;
        private final @NonNull EventHandler<? super MouseEvent> cellMouseHandler = new EventHandler<MouseEvent>(){

            public void handle(@NonNull MouseEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.DRAG_DETECTED) {
                    Label draggedLabel;
                    Label parent;
                    for (parent = draggedLabel = (Label)event.getSource(); parent != null && !(parent instanceof LayerCell); parent = parent.getParent()) {
                    }
                    if (parent == null) {
                        return;
                    }
                    LayerCell cell = (LayerCell)parent;
                    SelectionLabelDnDSupport.this.draggedCellIndex = cell.getIndex();
                    if (0 <= SelectionLabelDnDSupport.this.draggedCellIndex && SelectionLabelDnDSupport.this.draggedCellIndex < SelectionLabelDnDSupport.this.listView.getItems().size()) {
                        Dragboard dragboard = draggedLabel.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        ArrayList<Figure> items = new ArrayList<Figure>();
                        items.add((Figure)SelectionLabelDnDSupport.this.listView.getItems().get(SelectionLabelDnDSupport.this.draggedCellIndex));
                        SelectionLabelDnDSupport.this.io.write((Clipboard)dragboard, items);
                        dragboard.setDragView((Image)draggedLabel.snapshot(new SnapshotParameters(), null));
                        event.consume();
                    }
                } else {
                    SelectionLabelDnDSupport.this.draggedCellIndex = -1;
                }
            }
        };
        final @NonNull EventHandler<? super DragEvent> cellDragHandler = new EventHandler<DragEvent>(){

            public void handle(@NonNull DragEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                EventType t = event.getEventType();
                if (t == DragEvent.DRAG_DROPPED) {
                    this.onDragDropped(event);
                } else if (t == DragEvent.DRAG_OVER) {
                    this.onDragOver(event);
                }
            }

            private void onDragDropped(@NonNull DragEvent event) {
                if (this.isAcceptable(event)) {
                    Figure from;
                    LayersInspector.this.undoHelper.startCompositeEdit(null);
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    ObservableList items = SelectionLabelDnDSupport.this.listView.getItems();
                    LayerCell source = (LayerCell)((Object)event.getSource());
                    int droppedCellIndex = source.getIndex();
                    Figure to = droppedCellIndex >= 0 && droppedCellIndex < items.size() ? (Figure)items.get(droppedCellIndex) : null;
                    Figure figure = from = SelectionLabelDnDSupport.this.draggedCellIndex >= 0 && SelectionLabelDnDSupport.this.draggedCellIndex < items.size() ? (Figure)items.get(SelectionLabelDnDSupport.this.draggedCellIndex) : null;
                    if (to != null && from != null) {
                        LayersInspector.this.moveSelectedFiguresFromToLayer((Layer)from, (Layer)to);
                        event.setDropCompleted(true);
                    } else {
                        event.setDropCompleted(false);
                    }
                    event.consume();
                    LayersInspector.this.undoHelper.stopCompositeEdit();
                }
            }

            private boolean isAcceptable(@NonNull DragEvent event) {
                boolean isAcceptable = event.getGestureSource() instanceof Label && ((Label)event.getGestureSource()).getParent().getParent() instanceof LayerCell && ((LayerCell)((Label)event.getGestureSource()).getParent().getParent()).getListView() == SelectionLabelDnDSupport.this.listView;
                return isAcceptable;
            }

            private void onDragOver(@NonNull DragEvent event) {
                if (this.isAcceptable(event)) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    event.consume();
                }
            }
        };

        public SelectionLabelDnDSupport(ListView<Figure> listView, ClipboardIO<Figure> io) {
            this.listView = listView;
            this.io = io;
        }
    }
}

