/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.util.StringConverter;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.action.file.BrowseFileDirectoryAction;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.SimpleUriResolver;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.inspector.AbstractDrawingInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.fxbase.clipboard.ClipboardIO;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.control.ListViewUtil;
import org.jhotdraw8.fxbase.converter.StringConverterAdapter;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.xml.converter.UriXmlConverter;

public class StylesheetsInspector
extends AbstractDrawingInspector {
    @FXML
    private ListView<URI> listView;
    @FXML
    private Button addButton;
    @FXML
    private Button removeButton;
    @FXML
    private Button refreshButton;
    private ListProperty<URI> stylesheetsProperty;
    private Node node;
    private int counter;
    private int isReplacingDrawing;

    public StylesheetsInspector() {
        this(StylesheetsInspector.class.getResource("StylesheetsInspector.fxml"));
    }

    public StylesheetsInspector(@NonNull URL fxmlUrl) {
        this.init(fxmlUrl);
    }

    private void init(@NonNull URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
            this.listView.getItems().addListener(o -> this.onListChanged());
            this.addButton.addEventHandler(ActionEvent.ACTION, this::onAddAction);
            this.removeButton.addEventHandler(ActionEvent.ACTION, this::onRemoveAction);
            this.removeButton.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.listView.getSelectionModel().selectedIndexProperty(), (int)-1));
            this.refreshButton.addEventHandler(ActionEvent.ACTION, this::onRefreshAction);
            this.listView.setEditable(true);
            this.listView.setFixedCellSize(24.0);
            this.listView.setOnEditCommit(t -> this.listView.getItems().set(t.getIndex(), (Object)((URI)t.getNewValue())));
            ClipboardIO<URI> io = new ClipboardIO<URI>(){

                public void write(@NonNull Clipboard clipboard, @NonNull List<URI> items) {
                    if (items.size() != 1) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    ClipboardContent content = new ClipboardContent();
                    URI stylesheetUri = items.getFirst();
                    URI documentHome = (URI)StylesheetsInspector.this.getDrawing().get((MapAccessor)Drawing.DOCUMENT_HOME);
                    stylesheetUri = new SimpleUriResolver().absolutize(documentHome, stylesheetUri);
                    content.putUrl(stylesheetUri.toString());
                    clipboard.setContent((Map)content);
                }

                public @Nullable List<URI> read(@NonNull Clipboard clipboard) {
                    ArrayList<URI> list;
                    if (clipboard.hasUrl()) {
                        list = new ArrayList<URI>();
                        URI documentHome = (URI)StylesheetsInspector.this.getDrawing().get((MapAccessor)Drawing.DOCUMENT_HOME);
                        URI dragboardUri = URI.create(clipboard.getUrl());
                        URI stylesheetUri = documentHome.relativize(dragboardUri);
                        list.add(stylesheetUri);
                    } else if (clipboard.hasFiles()) {
                        list = new ArrayList();
                        URI documentHome = (URI)StylesheetsInspector.this.getDrawing().get((MapAccessor)Drawing.DOCUMENT_HOME);
                        for (File f : clipboard.getFiles()) {
                            URI dragboardUri = f.toURI();
                            URI stylesheetUri = new SimpleUriResolver().absolutize(documentHome, dragboardUri);
                            list.add(stylesheetUri);
                        }
                    } else {
                        list = null;
                    }
                    return list;
                }

                public boolean canRead(@NonNull Clipboard clipboard) {
                    return clipboard.hasFiles() || clipboard.hasUrl();
                }
            };
            StringConverterAdapter uriConverter = new StringConverterAdapter((Converter)new UriXmlConverter());
            ListViewUtil.addDragAndDropSupport(this.listView, arg_0 -> this.lambda$init$3((StringConverter)uriConverter, arg_0), (ClipboardIO)io, this::forwardUndoableEditEvent);
        });
    }

    private ContextMenu createCellContextMenu(TextFieldListCell<URI> cell) {
        ContextMenu cm = new ContextMenu();
        MenuItem mi = new MenuItem();
        mi.setText(InspectorLabels.getResources().getString("file.browseFileDirectory.text"));
        WeakReference<StylesheetsInspector> weakInspector = new WeakReference<StylesheetsInspector>(this);
        WeakReference<TextFieldListCell<URI>> weakCell = new WeakReference<TextFieldListCell<URI>>(cell);
        mi.setOnAction(event -> {
            StylesheetsInspector stylesheetsInspector = (StylesheetsInspector)weakInspector.get();
            TextFieldListCell theCell = (TextFieldListCell)weakCell.get();
            if (stylesheetsInspector != null && theCell != null) {
                stylesheetsInspector.onBrowseFileDirectory((ActionEvent)event, (TextFieldListCell<URI>)theCell);
            }
        });
        cm.getItems().add((Object)mi);
        return cm;
    }

    private void onBrowseFileDirectory(ActionEvent actionEvent, TextFieldListCell<URI> cell) {
        URI uri = (URI)cell.getItem();
        BrowseFileDirectoryAction.browseFileDirectory((URI)uri);
    }

    @Override
    protected void onDrawingChanged(@Nullable ObservableValue<? extends Drawing> observable, @Nullable Drawing oldValue, @Nullable Drawing newValue) {
        ++this.isReplacingDrawing;
        if (oldValue != null) {
            this.listView.getItems().clear();
        }
        if (newValue != null) {
            ImmutableList stylesheets = (ImmutableList)newValue.get((MapAccessor)Drawing.AUTHOR_STYLESHEETS);
            if (stylesheets == null) {
                this.listView.getItems().clear();
            } else {
                this.listView.getItems().setAll((Collection)stylesheets.asList());
            }
        }
        this.counter = 0;
        --this.isReplacingDrawing;
    }

    private void onListChanged() {
        if (this.isReplacingDrawing != 0) {
            return;
        }
        this.getModel().set(this.getDrawing(), Drawing.AUTHOR_STYLESHEETS, VectorList.copyOf((Iterable)this.listView.getItems()));
        this.updateAllFigures();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void onRemoveAction(ActionEvent event) {
        ObservableList items = this.listView.getItems();
        ArrayList indices = new ArrayList(this.listView.getSelectionModel().getSelectedIndices());
        Collections.sort(indices);
        for (int i = indices.size() - 1; i >= 0; --i) {
            items.remove(((Integer)indices.get(i)).intValue());
        }
    }

    private void onAddAction(ActionEvent event) {
        Drawing drawing = this.getDrawing();
        if (drawing == null) {
            return;
        }
        URI documentHome = (URI)drawing.get((MapAccessor)Drawing.DOCUMENT_HOME);
        URI uri = URI.create("stylesheet" + ++this.counter + ".css");
        uri = new SimpleUriResolver().absolutize(documentHome, uri);
        this.listView.getItems().add((Object)uri);
    }

    private void onRefreshAction(ActionEvent event) {
        this.updateAllFigures();
    }

    private void updateAllFigures() {
        Drawing drawing = this.getDrawing();
        DrawingView subject = (DrawingView)this.getSubject();
        if (drawing == null || subject == null) {
            return;
        }
        this.getDrawing().updateStyleManager();
        this.getDrawing().updateAllCss(subject);
        for (Figure f : this.getDrawing().preorderIterable()) {
            this.getDrawingModel().fireLayoutInvalidated(f);
        }
    }

    private /* synthetic */ ListCell lambda$init$3(StringConverter uriConverter, ListView param) {
        TextFieldListCell cell = new TextFieldListCell(uriConverter);
        cell.emptyProperty().addListener((obs, wasEmpty, isNowEmpty) -> {
            if (isNowEmpty.booleanValue()) {
                cell.setContextMenu(null);
            } else {
                cell.setContextMenu(this.createCellContextMenu((TextFieldListCell<URI>)cell));
            }
        });
        return cell;
    }
}

