/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import org.jhotdraw8.annotation.NonNull;

public class ZoomToolbar
extends BorderPane {
    private final double LOG2 = Math.log(2.0);
    private final double zoomPowerIncrement = 0.5;
    @FXML
    private Slider zoomSlider;
    private final DoubleProperty zoomPower = new SimpleDoubleProperty((Object)this, "zoomPower", 0.0);
    private int isUpdating = 0;
    private final DoubleProperty zoomFactor = new SimpleDoubleProperty((Object)this, "zoomFactor", 1.0);

    public ZoomToolbar() {
        this(ZoomToolbar.class.getResource("ZoomToolbar.fxml"));
    }

    public ZoomToolbar(@NonNull URL fxmlUrl) {
        this.zoomFactor.addListener((o, oldv, newv) -> {
            if (this.isUpdating++ == 0) {
                this.zoomPower.set(Math.log(newv.doubleValue()) / this.LOG2);
            }
            --this.isUpdating;
        });
        this.zoomPower.addListener((o, oldv, newv) -> {
            if (this.isUpdating++ == 0) {
                this.zoomFactor.set(Math.pow(2.0, newv.doubleValue()));
            }
            --this.isUpdating;
        });
        this.init(fxmlUrl);
    }

    private void init(@NonNull URL fxmlUrl) {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        try (InputStream in = fxmlUrl.openStream();){
            this.setCenter((Node)loader.load(in));
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        this.zoomSlider.valueProperty().bindBidirectional((Property)this.zoomPower);
        this.zoomSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(this){

            public @NonNull String toString(@NonNull Double object) {
                return Integer.toString(object.intValue());
            }

            public @NonNull Double fromString(String string) {
                return 0.0;
            }
        });
    }

    public @NonNull DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double newValue) {
        this.zoomFactor.set(newValue);
    }

    public double getZoomFactor() {
        return this.zoomFactor.get();
    }

    @FXML
    void zoomMinus(ActionEvent event) {
        this.zoomPower.set((double)Math.round((this.zoomPower.get() - 0.5) / 0.5) * 0.5);
    }

    @FXML
    void zoomPlus(ActionEvent event) {
        this.zoomPower.set((double)Math.round((this.zoomPower.get() + 0.5) / 0.5) * 0.5);
    }

    public @NonNull DoubleProperty minProperty() {
        return this.zoomSlider.minProperty();
    }

    public @NonNull DoubleProperty maxProperty() {
        return this.zoomSlider.maxProperty();
    }

    public double getMin() {
        return this.minProperty().get();
    }

    public double getMax() {
        return this.maxProperty().get();
    }

    public void setMin(double value) {
        this.minProperty().set(value);
    }

    public void setMax(double value) {
        this.maxProperty().set(value);
    }
}

