/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public interface OutputFormat {
    public void setOptions(@NonNull ImmutableMap<Key<?>, Object> var1);

    public @NonNull ImmutableMap<Key<?>, Object> getOptions();

    default public void write(@NonNull URI uri, @NonNull Drawing drawing, @NonNull WorkState<Void> workState) throws IOException {
        this.write(Paths.get(uri), drawing, workState);
    }

    default public void write(@NonNull Path file, @NonNull Drawing drawing, @NonNull WorkState<Void> workState) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            this.write(out, file.getParent().toUri(), drawing, workState);
        }
    }

    public void write(@NonNull OutputStream var1, @Nullable URI var2, @NonNull Drawing var3, @NonNull WorkState<Void> var4) throws IOException;
}

