/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.lang.reflect.Type;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcollection.typesafekey.CompositeMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;

public abstract class AbstractMapAccessor<T>
implements CompositeMapAccessor<T> {
    private static final long serialVersionUID = 1L;
    private final @NonNull String name;
    private final @Nullable T defaultValue;
    private final @NonNull Type type;
    private final @NonNull ImmutableSequencedSet<MapAccessor<?>> subAccessors;

    public AbstractMapAccessor(@NonNull String name, Class<T> type, @NonNull MapAccessor<?>[] subAccessors, T defaultValue) {
        this(name, type, null, subAccessors, defaultValue);
    }

    public AbstractMapAccessor(@NonNull String name, @Nullable Class<?> type, @Nullable Class<?>[] typeParameters, @NonNull MapAccessor<?>[] subAccessors, @Nullable T defaultValue) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(type, "clazz");
        Objects.requireNonNull(defaultValue, "defaultValue");
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.subAccessors = ChampVectorSet.of((Object[])subAccessors);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Type getValueType() {
        return this.type;
    }

    public @Nullable T getDefaultValue() {
        return this.defaultValue;
    }

    public @NonNull String toString() {
        String keyClass = this.getClass().getName();
        return keyClass.substring(keyClass.lastIndexOf(46) + 1) + "{name:" + this.name + " type:" + String.valueOf(this.getValueType()) + "}";
    }

    public @NonNull ImmutableSequencedSet<MapAccessor<?>> getSubAccessors() {
        return this.subAccessors;
    }

    public boolean isTransient() {
        return false;
    }
}

