/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.converter.FontCssConverter;
import org.jhotdraw8.draw.css.value.CssFont;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class FontStyleableMapAccessor
extends AbstractStyleableMapAccessor<CssFont>
implements NonNullMapAccessor<CssFont> {
    private static final long serialVersionUID = 1L;
    private final @NonNull MapAccessor<String> familyKey;
    private final @NonNull MapAccessor<FontWeight> weightKey;
    private final @NonNull MapAccessor<FontPosture> postureKey;
    private final @NonNull MapAccessor<@NonNull CssSize> sizeKey;
    private final Converter<CssFont> converter = new FontCssConverter(false);

    public FontStyleableMapAccessor(@NonNull String name, @NonNull MapAccessor<String> familyKey, @NonNull MapAccessor<FontWeight> weightKey, @NonNull MapAccessor<FontPosture> postureKey, @NonNull MapAccessor<@NonNull CssSize> sizeKey) {
        super(name, CssFont.class, new MapAccessor[]{familyKey, sizeKey, weightKey, postureKey}, CssFont.font((String)familyKey.getDefaultValue(), (FontWeight)weightKey.getDefaultValue(), (FontPosture)postureKey.getDefaultValue(), (CssSize)sizeKey.getDefaultValue()));
        this.familyKey = familyKey;
        this.sizeKey = sizeKey;
        this.weightKey = weightKey;
        this.postureKey = postureKey;
    }

    public CssFont get(@NonNull Map<? super Key<?>, Object> a) {
        CssFont f = CssFont.font((String)this.familyKey.get(a), (FontWeight)this.weightKey.get(a), (FontPosture)this.postureKey.get(a), (CssSize)this.sizeKey.get(a));
        return f;
    }

    public @NonNull Converter<CssFont> getCssConverter() {
        return this.converter;
    }

    public CssFont remove(@NonNull Map<? super Key<?>, Object> a) {
        Object oldValue = this.get((Map)a);
        this.familyKey.remove(a);
        this.weightKey.remove(a);
        this.postureKey.remove(a);
        this.sizeKey.remove(a);
        return oldValue;
    }

    public void set(@NonNull Map<? super Key<?>, Object> a, @Nullable CssFont value) {
        if (value == null) {
            this.remove((Map)a);
        } else {
            this.familyKey.put(a, (Object)value.getFamily());
            this.weightKey.put(a, (Object)value.getWeight());
            this.postureKey.put(a, (Object)value.getPosture());
            this.sizeKey.put(a, (Object)value.getSize());
        }
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, CssFont value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.familyKey.put(a, (Object)value.getFamily());
        a = this.weightKey.put(a, (Object)value.getWeight());
        a = this.postureKey.put(a, (Object)value.getPosture());
        return this.sizeKey.put(a, (Object)value.getSize());
    }

    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        a = this.familyKey.remove(a);
        a = this.weightKey.remove(a);
        a = this.postureKey.remove(a);
        return this.sizeKey.remove(a);
    }
}

