/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.geometry.Point3D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.css.converter.Point3DConverter;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class Point3DStyleableMapAccessor
extends AbstractStyleableMapAccessor<Point3D>
implements NonNullMapAccessor<Point3D> {
    private static final long serialVersionUID = 1L;
    private final @NonNull MapAccessor<Double> xKey;
    private final @NonNull MapAccessor<Double> yKey;
    private final @NonNull MapAccessor<Double> zKey;
    private final Converter<Point3D> converter;

    public Point3DStyleableMapAccessor(String name, @NonNull MapAccessor<Double> xKey, @NonNull MapAccessor<Double> yKey, @NonNull MapAccessor<Double> zKey) {
        this(name, xKey, yKey, zKey, (Converter<Point3D>)new Point3DConverter(false));
    }

    public Point3DStyleableMapAccessor(String name, @NonNull MapAccessor<Double> xKey, @NonNull MapAccessor<Double> yKey, @NonNull MapAccessor<Double> zKey, Converter<Point3D> converter) {
        super(name, Point3D.class, new MapAccessor[]{xKey, yKey, zKey}, new Point3D(((Double)xKey.getDefaultValue()).doubleValue(), ((Double)yKey.getDefaultValue()).doubleValue(), ((Double)zKey.getDefaultValue()).doubleValue()));
        this.converter = converter;
        this.xKey = xKey;
        this.yKey = yKey;
        this.zKey = zKey;
    }

    public @NonNull Converter<Point3D> getCssConverter() {
        return this.converter;
    }

    public @NonNull Point3D get(@NonNull Map<? super Key<?>, Object> a) {
        Double x = (Double)this.xKey.get(a);
        Double y = (Double)this.yKey.get(a);
        Double z = (Double)this.zKey.get(a);
        return new Point3D(x == null ? 0.0 : x, y == null ? 0.0 : y, z == null ? 0.0 : z);
    }

    public void set(@NonNull Map<? super Key<?>, Object> a, @Nullable Point3D value) {
        if (value == null) {
            this.remove(a);
        } else {
            this.xKey.put(a, (Object)value.getX());
            this.yKey.put(a, (Object)value.getY());
            this.zKey.put(a, (Object)value.getZ());
        }
    }

    public @NonNull Point3D remove(@NonNull Map<? super Key<?>, Object> a) {
        Point3D oldValue = this.get(a);
        this.xKey.remove(a);
        this.yKey.remove(a);
        this.zKey.remove(a);
        return oldValue;
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable Point3D value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.xKey.put(a, (Object)value.getX());
        a = this.yKey.put(a, (Object)value.getY());
        return this.zKey.put(a, (Object)value.getZ());
    }

    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        a = this.xKey.remove(a);
        a = this.yKey.remove(a);
        return this.zKey.remove(a);
    }
}

