/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.geometry.Rectangle2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.css.converter.Rectangle2DConverter;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class Rectangle2DStyleableMapAccessor
extends AbstractStyleableMapAccessor<Rectangle2D>
implements NonNullMapAccessor<Rectangle2D> {
    private static final long serialVersionUID = 1L;
    private final @NonNull NonNullMapAccessor<Double> xKey;
    private final @NonNull NonNullMapAccessor<Double> yKey;
    private final @NonNull NonNullMapAccessor<Double> widthKey;
    private final @NonNull NonNullMapAccessor<Double> heightKey;
    private final Converter<Rectangle2D> converter = new Rectangle2DConverter(false);

    public Rectangle2DStyleableMapAccessor(@NonNull String name, @NonNull NonNullMapAccessor<Double> xKey, @NonNull NonNullMapAccessor<Double> yKey, @NonNull NonNullMapAccessor<Double> widthKey, @NonNull NonNullMapAccessor<Double> heightKey) {
        super(name, Rectangle2D.class, (MapAccessor<?>[])new NonNullMapAccessor[]{xKey, yKey, widthKey, heightKey}, new Rectangle2D(((Double)xKey.getDefaultValueNonNull()).doubleValue(), ((Double)yKey.getDefaultValueNonNull()).doubleValue(), ((Double)widthKey.getDefaultValueNonNull()).doubleValue(), ((Double)heightKey.getDefaultValueNonNull()).doubleValue()));
        this.xKey = xKey;
        this.yKey = yKey;
        this.widthKey = widthKey;
        this.heightKey = heightKey;
    }

    public @NonNull Rectangle2D get(@NonNull Map<? super Key<?>, Object> a) {
        return new Rectangle2D(((Double)this.xKey.getNonNull(a)).doubleValue(), ((Double)this.yKey.getNonNull(a)).doubleValue(), Double.max(0.0, (Double)this.widthKey.getNonNull(a)), Double.max(0.0, (Double)this.heightKey.getNonNull(a)));
    }

    public @NonNull Converter<Rectangle2D> getCssConverter() {
        return this.converter;
    }

    public @NonNull Rectangle2D remove(@NonNull Map<? super Key<?>, Object> a) {
        Rectangle2D oldValue = this.get(a);
        this.xKey.remove(a);
        this.yKey.remove(a);
        this.widthKey.remove(a);
        this.heightKey.remove(a);
        return oldValue;
    }

    public void set(@NonNull Map<? super Key<?>, Object> a, @Nullable Rectangle2D value) {
        if (value == null) {
            this.remove(a);
        } else {
            this.xKey.put(a, (Object)value.getMinX());
            this.yKey.put(a, (Object)value.getMinY());
            this.widthKey.put(a, (Object)value.getWidth());
            this.heightKey.put(a, (Object)value.getHeight());
        }
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable Rectangle2D value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.xKey.put(a, (Object)value.getMinX());
        a = this.yKey.put(a, (Object)value.getMinY());
        a = this.widthKey.put(a, (Object)value.getWidth());
        return this.heightKey.put(a, (Object)value.getHeight());
    }

    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        a = this.xKey.remove(a);
        a = this.yKey.remove(a);
        a = this.widthKey.remove(a);
        return this.heightKey.remove(a);
    }
}

