/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.geometry.Point2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.css.converter.Scale2DCssConverter;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class Scale2DStyleableMapAccessor
extends AbstractStyleableMapAccessor<Point2D> {
    private static final long serialVersionUID = 1L;
    private final @NonNull MapAccessor<Double> xKey;
    private final @NonNull MapAccessor<Double> yKey;
    private final Converter<Point2D> converter = new Scale2DCssConverter();

    public Scale2DStyleableMapAccessor(String name, @NonNull MapAccessor<Double> xKey, @NonNull MapAccessor<Double> yKey) {
        super(name, Point2D.class, new MapAccessor[]{xKey, yKey}, new Point2D(((Double)xKey.getDefaultValue()).doubleValue(), ((Double)yKey.getDefaultValue()).doubleValue()));
        this.xKey = xKey;
        this.yKey = yKey;
    }

    public @NonNull Point2D get(@NonNull Map<? super Key<?>, Object> a) {
        Double x = (Double)this.xKey.get(a);
        Double y = (Double)this.yKey.get(a);
        return new Point2D(x == null ? 0.0 : x, y == null ? 0.0 : y);
    }

    public @NonNull Converter<Point2D> getCssConverter() {
        return this.converter;
    }

    public @NonNull Point2D remove(@NonNull Map<? super Key<?>, Object> a) {
        Point2D oldValue = this.get(a);
        this.xKey.remove(a);
        this.yKey.remove(a);
        return oldValue;
    }

    public void set(@NonNull Map<? super Key<?>, Object> a, @Nullable Point2D value) {
        if (value == null) {
            this.remove(a);
        } else {
            this.xKey.put(a, (Object)value.getX());
            this.yKey.put(a, (Object)value.getY());
        }
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable Point2D value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.xKey.put(a, (Object)value.getX());
        return this.yKey.put(a, (Object)value.getY());
    }

    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        a = this.xKey.remove(a);
        return this.yKey.remove(a);
    }
}

