/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModelEvent;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public interface DrawingModel
extends Observable,
TreeModel<Figure> {
    public static final String DRAWING_PROPERTY = "drawing";

    public @NonNull CopyOnWriteArrayList<Listener<DrawingModelEvent>> getDrawingModelListeners();

    public @NonNull CopyOnWriteArrayList<InvalidationListener> getInvalidationListeners();

    public @NonNull ObjectProperty<Drawing> drawingProperty();

    default public void addDrawingModelListener(Listener<DrawingModelEvent> l) {
        this.getDrawingModelListeners().add(l);
    }

    default public void removeDrawingModelListener(Listener<DrawingModelEvent> l) {
        this.getDrawingModelListeners().remove(l);
    }

    default public void addListener(InvalidationListener l) {
        this.getInvalidationListeners().add(l);
    }

    default public void removeListener(InvalidationListener l) {
        this.getInvalidationListeners().remove(l);
    }

    default public Drawing getDrawing() {
        return (Drawing)this.drawingProperty().get();
    }

    default public void setDrawing(Drawing root) {
        this.drawingProperty().set((Object)root);
    }

    default public @NonNull List<Figure> getChildren(@NonNull Figure figure) {
        return figure.getChildren();
    }

    default public int getChildCount(@NonNull Figure figure) {
        return this.getChildren(figure).size();
    }

    default public @NonNull Figure getChild(@NonNull Figure parent, int index) {
        return this.getChildren(parent).get(index);
    }

    public void removeFromParent(@NonNull Figure var1);

    public Figure removeFromParent(Figure var1, int var2);

    public void insertChildAt(@NonNull Figure var1, @NonNull Figure var2, int var3);

    default public void addChildTo(@NonNull Figure child, @NonNull Figure parent) {
        this.insertChildAt(child, parent, this.getChildCount(parent));
    }

    public <T> @Nullable T set(@NonNull Figure var1, MapAccessor<T> var2, @Nullable T var3);

    public <T> @Nullable T remove(@NonNull Figure var1, MapAccessor<T> var2);

    public <T> @NonNull T setNonNull(@NonNull Figure var1, @NonNull NonNullMapAccessor<T> var2, @NonNull T var3);

    default public <T> @Nullable T get(@NonNull Figure figure, @NonNull MapAccessor<T> key) {
        return (T)figure.get(key);
    }

    default public <T> @NonNull T getNonNull(@NonNull Figure figure, @NonNull NonNullMapAccessor<T> key) {
        return (T)figure.getNonNull(key);
    }

    public void reshapeInLocal(Figure var1, Transform var2);

    public void reshapeInParent(Figure var1, Transform var2);

    public void translateInParent(Figure var1, CssPoint2D var2);

    public void reshapeInLocal(Figure var1, double var2, double var4, double var6, double var8);

    public void reshapeInLocal(Figure var1, CssSize var2, CssSize var3, CssSize var4, CssSize var5);

    public void layout(Figure var1, RenderContext var2);

    public void disconnect(Figure var1);

    public boolean isValidating();

    public ReadOnlyBooleanProperty validatingProperty();

    public void updateCss(Figure var1);

    default public void fireDrawingModelEvent(DrawingModelEvent event) {
        for (Listener<DrawingModelEvent> l : this.getDrawingModelListeners()) {
            l.handle((Object)event);
        }
    }

    public void validate(RenderContext var1);

    default public void fireNodeInvalidated(@NonNull Figure f) {
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    default public <T> void firePropertyValueChanged(Figure f, Key<T> key, @Nullable T oldValue, @Nullable T newValue, boolean wasAdded, boolean wasRemoved) {
        this.fireDrawingModelEvent(DrawingModelEvent.propertyValueChanged(this, f, key, oldValue, newValue, wasAdded, wasRemoved));
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    default public void fireTransformInvalidated(Figure f) {
        this.fireDrawingModelEvent(DrawingModelEvent.transformChanged(this, f));
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    default public void fireLayoutInvalidated(Figure f) {
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    default public void fireStyleInvalidated(Figure f) {
        this.fireDrawingModelEvent(DrawingModelEvent.styleInvalidated(this, f));
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    default public void fireDrawingModelInvalidated() {
        for (InvalidationListener l : new ArrayList<InvalidationListener>(this.getInvalidationListeners())) {
            l.invalidated((Observable)this);
        }
    }

    public void transformInParent(Figure var1, Transform var2);

    public void transformInLocal(Figure var1, Transform var2);

    public <T> @Nullable T remove(Figure var1, Key<T> var2);

    public <T> @NonNull Property<T> propertyAt(Figure var1, Key<T> var2);
}

