/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.model;

import java.lang.ref.WeakReference;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelEvent;
import org.jhotdraw8.fxbase.event.SimpleWeakListener;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class DrawingModelFigureProperty<T>
extends ReadOnlyObjectWrapper<T> {
    private final @NonNull DrawingModel model;
    protected final @Nullable WeakReference<Figure> figure;
    private final @Nullable Key<T> key;
    private final @Nullable Listener<DrawingModelEvent> modelListener;
    private final @Nullable SimpleWeakListener<DrawingModelEvent> weakListener;
    private final boolean isDeclaredKey;

    public DrawingModelFigureProperty(@NonNull DrawingModel model, Figure figure, Key<T> key) {
        this(model, figure, key, false);
    }

    public DrawingModelFigureProperty(@NonNull DrawingModel model, @Nullable Figure figure, @Nullable Key<T> key, boolean allKeys) {
        this.model = model;
        this.key = key;
        this.figure = new WeakReference<Figure>(figure);
        boolean bl = this.isDeclaredKey = figure != null && Figure.getDeclaredAndInheritedMapAccessors(figure.getClass()).contains(key);
        if (key != null) {
            this.modelListener = event -> {
                DrawingModelEvent.EventType eventType = event.getEventType();
                if (event.getEventType() == DrawingModelEvent.EventType.PROPERTY_VALUE_CHANGED && this.figure.get() == event.getNode()) {
                    if (this.key == event.getKey()) {
                        Object newValue = event.getNewValue();
                        if (super.get() != newValue) {
                            this.set(newValue);
                        }
                    } else if (allKeys) {
                        this.updateValue();
                    }
                }
            };
            this.weakListener = new SimpleWeakListener(this.modelListener, model::removeDrawingModelListener);
            model.addDrawingModelListener((Listener<DrawingModelEvent>)this.weakListener);
        } else {
            this.modelListener = null;
            this.weakListener = null;
        }
    }

    public @Nullable T getValue() {
        Figure f = (Figure)this.figure.get();
        Object temp = this.isDeclaredKey && f != null && this.key != null ? f.get((MapAccessor)this.key) : null;
        return (T)temp;
    }

    public void setValue(@Nullable T value) {
        if (this.isDeclaredKey && this.figure != null && this.key != null) {
            if (value != null && !this.key.isAssignable(value)) {
                throw new IllegalArgumentException("value is not assignable " + String.valueOf(value));
            }
            Figure f = (Figure)this.figure.get();
            if (f != null) {
                this.model.set(f, this.key, value);
            }
        }
        super.setValue(value);
    }

    public void unbind() {
        super.unbind();
        this.model.removeDrawingModelListener((Listener<DrawingModelEvent>)this.weakListener);
    }

    protected void updateValue() {
    }
}

