/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.popup;

import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.popup.AbstractPicker;

public class EnumPicker<T extends Enum<T>>
extends AbstractPicker<T> {
    private ContextMenu contextMenu;
    private MenuItem noneItem;
    private BiConsumer<Boolean, T> callback;
    private final @NonNull Converter<T> converter;
    private final @NonNull Class<T> enumClazz;

    public EnumPicker(@NonNull Class<T> enumClazz, @NonNull Converter<T> converter) {
        this.enumClazz = enumClazz;
        this.converter = converter;
    }

    private void init() {
        Resources labels = DrawLabels.getResources();
        this.contextMenu = new ContextMenu();
        for (Enum enumConstant : (Enum[])this.enumClazz.getEnumConstants()) {
            String s = this.converter.toString((Object)enumConstant);
            MenuItem valueItem = new MenuItem(s);
            valueItem.setOnAction(e -> this.callback.accept(true, (Boolean)((Object)enumConstant)));
            this.contextMenu.getItems().add((Object)valueItem);
        }
        MenuItem unsetItem = new MenuItem();
        unsetItem.setOnAction(e -> this.callback.accept(false, null));
        this.noneItem = new MenuItem();
        this.noneItem.setOnAction(e -> this.callback.accept(true, null));
        labels.configureMenuItem(unsetItem, "value.unset");
        labels.configureMenuItem(this.noneItem, "value.none");
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), unsetItem, this.noneItem});
    }

    private void update(T initialValue) {
        Converter<T> converter;
        if (this.contextMenu == null) {
            this.init();
        }
        if ((converter = this.converter) instanceof CssConverter) {
            CssConverter cssConverter = (CssConverter)converter;
            this.noneItem.setVisible(cssConverter.isNullable());
        }
    }

    @Override
    public void show(Node anchor, double screenX, double screenY, T initialValue, BiConsumer<Boolean, T> callback) {
        this.update(initialValue);
        this.callback = callback;
        this.contextMenu.show(anchor, screenX, screenY);
    }
}

