/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.popup;

import java.text.ParseException;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.popup.AbstractPicker;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class ExamplesPicker<T>
extends AbstractPicker<T> {
    private ContextMenu contextMenu;
    private MenuItem noneItem;
    private BiConsumer<Boolean, T> callback;
    private final @NonNull ImmutableList<String> examples;
    private final @NonNull Converter<T> converter;

    public ExamplesPicker(@NonNull ImmutableList<String> examples, @NonNull Converter<T> converter) {
        this.examples = examples;
        this.converter = converter;
    }

    private void init() {
        Resources labels = DrawLabels.getResources();
        this.contextMenu = new ContextMenu();
        for (String s : this.examples) {
            MenuItem valueItem = new MenuItem(s);
            valueItem.setOnAction(e -> {
                try {
                    this.callback.accept(true, (Boolean)this.converter.fromString((CharSequence)s));
                }
                catch (ParseException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
                }
            });
            this.contextMenu.getItems().add((Object)valueItem);
        }
        MenuItem unsetItem = new MenuItem();
        unsetItem.setOnAction(e -> this.callback.accept(false, null));
        this.noneItem = new MenuItem();
        this.noneItem.setOnAction(e -> this.callback.accept(true, null));
        labels.configureMenuItem(unsetItem, "value.unset");
        labels.configureMenuItem(this.noneItem, "value.none");
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), unsetItem, this.noneItem});
    }

    private void update(T initialValue) {
        Converter<T> converter;
        if (this.contextMenu == null) {
            this.init();
        }
        if ((converter = this.converter) instanceof CssConverter) {
            CssConverter cssConverter = (CssConverter)converter;
            this.noneItem.setVisible(cssConverter.isNullable());
        }
    }

    @Override
    public void show(Node anchor, double screenX, double screenY, T initialValue, BiConsumer<Boolean, T> callback) {
        this.update(initialValue);
        this.callback = callback;
        this.contextMenu.show(anchor, screenX, screenY);
    }
}

