/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.Set;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.ReadOnlySetWrapper;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.util.Duration;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.SimpleDrawingModel;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;

public class InteractiveHandleRenderer {
    private static final @NonNull String DRAWING_VIEW = "drawingView";
    private final @NonNull Group handlesPane = new Group();
    private final @NonNull ObjectProperty<DrawingView> drawingView = new SimpleObjectProperty((Object)this, "drawingView");
    private final @NonNull Set<Figure> dirtyHandles = new HashSet<Figure>();
    private final @NonNull SetProperty<Figure> selectedFigures = new SimpleSetProperty((Object)this, "selectedFigures", FXCollections.observableSet(new LinkedHashSet()));
    private final @NonNull ObjectProperty<DrawingEditor> editor = new SimpleObjectProperty((Object)this, "editor", null);
    private final @NonNull SequencedMap<Node, Handle> nodeToHandleMap = new LinkedHashMap<Node, Handle>();
    private final @NonNull Listener<TreeModelEvent<Figure>> treeModelListener = this::onTreeModelEvent;
    private final @NonNull SequencedMap<Figure, List<Handle>> handles = new LinkedHashMap<Figure, List<Handle>>();
    private final @NonNull ObservableSet<Handle> handlesView = FXCollections.observableSet(new LinkedHashSet());
    private final @NonNull ReadOnlySetWrapper<Handle> handlesProperty = new ReadOnlySetWrapper((Object)this, "handles", FXCollections.unmodifiableObservableSet(this.handlesView));
    private final @NonNull ArrayList<Handle> secondaryHandles = new ArrayList();
    private final @NonNull ObjectProperty<Bounds> clipBounds = new SimpleObjectProperty((Object)this, "clipBounds", (Object)new BoundingBox(0.0, 0.0, 800.0, 600.0));
    private final @NonNull NonNullObjectProperty<DrawingModel> model = new NonNullObjectProperty((Object)this, "model", (Object)new SimpleDrawingModel());
    private boolean recreateHandles;
    private boolean handlesAreValid;
    private @Nullable Runnable repainter = null;

    public InteractiveHandleRenderer() {
        this.handlesPane.setManaged(false);
        this.handlesPane.setAutoSizeChildren(false);
        this.model.addListener(this::onDrawingModelChanged);
        this.clipBounds.addListener(this::onClipBoundsChanged);
        this.selectedFigures.addListener(change -> this.recreateHandles());
    }

    private void onDrawingModelChanged(@NonNull Observable o, @Nullable DrawingModel oldValue, @Nullable DrawingModel newValue) {
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.treeModelListener);
        }
        if (newValue != null) {
            newValue.addTreeModelListener(this.treeModelListener);
            this.onRootChanged();
        }
    }

    protected void createHandles(@NonNull Map<Figure, List<Handle>> handles) {
        HandleType handleType;
        ArrayList<Handle> list;
        ArrayList<Figure> selection = new ArrayList<Figure>((Collection<Figure>)this.getSelectedFigures());
        if (selection.size() > 1) {
            Figure anchor;
            if (this.getEditor().getAnchorHandleType() != null) {
                anchor = (Figure)selection.getFirst();
                list = handles.computeIfAbsent(anchor, k -> new ArrayList());
                anchor.createHandles(this.getEditor().getAnchorHandleType(), list);
            }
            if (this.getEditor().getLeadHandleType() != null) {
                anchor = (Figure)selection.getLast();
                list = handles.computeIfAbsent(anchor, k -> new ArrayList());
                anchor.createHandles(this.getEditor().getLeadHandleType(), list);
            }
        }
        if ((handleType = this.getEditor().getHandleType()) != null) {
            list = new ArrayList();
            for (Figure figure : selection) {
                figure.createHandles(handleType, list);
            }
            for (Handle h : list) {
                Figure figure = h.getOwner();
                handles.computeIfAbsent(figure, k -> new ArrayList()).add(h);
            }
        }
    }

    public @NonNull ObjectProperty<DrawingEditor> editorProperty() {
        return this.editor;
    }

    public @NonNull ObjectProperty<DrawingView> drawingViewProperty() {
        return this.drawingView;
    }

    public @Nullable Handle findHandle(double vx, double vy) {
        if (this.recreateHandles) {
            return null;
        }
        double tolerance = this.getEditor().getTolerance();
        ArrayList entries = new ArrayList(this.nodeToHandleMap.entrySet());
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry e = entries.get(i);
            Handle handle = (Handle)e.getValue();
            if (!handle.isSelectable() || !handle.contains(this.getDrawingViewNonNull(), vx, vy, tolerance)) continue;
            return handle;
        }
        return null;
    }

    private @NonNull DrawingView getDrawingViewNonNull() {
        return Objects.requireNonNull((DrawingView)this.drawingView.get(), DRAWING_VIEW);
    }

    @Nullable DrawingEditor getEditor() {
        return (DrawingEditor)this.editorProperty().get();
    }

    public @NonNull Set<Figure> getFiguresWithCompatibleHandle(@NonNull Collection<Figure> figures, Handle master) {
        this.validateHandles();
        HashMap result = new HashMap();
        block0: for (Map.Entry entry : this.handles.entrySet()) {
            if (!figures.contains(entry.getKey())) continue;
            for (Handle h : (List)entry.getValue()) {
                if (!h.isCompatible(master)) continue;
                result.put((Figure)entry.getKey(), null);
                continue block0;
            }
        }
        return result.keySet();
    }

    public @NonNull Node getNode() {
        return this.handlesPane;
    }

    @NonNull ObservableSet<Figure> getSelectedFigures() {
        return (ObservableSet)this.selectedFiguresProperty().get();
    }

    public void invalidateHandleNodes() {
        this.handlesAreValid = false;
        this.dirtyHandles.addAll(this.handles.keySet());
    }

    public void invalidateHandles() {
        this.handlesAreValid = false;
    }

    public void revalidateHandles() {
        this.invalidateHandles();
        this.repaint();
    }

    public void jiggleHandles() {
        this.validateHandles();
        final List copiedList = this.handles.values().stream().flatMap(Collection::stream).toList();
        final double amount = 0.1;
        Transition flash = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)100.0));
                this.setCycleCount(2);
                this.setAutoReverse(true);
            }

            protected void interpolate(double frac) {
                for (Handle h : copiedList) {
                    Node node = h.getNode(InteractiveHandleRenderer.this.getDrawingViewNonNull());
                    node.setScaleX(1.0 + frac * amount);
                    node.setScaleY(1.0 + frac * amount);
                }
            }
        };
        flash.play();
    }

    public @NonNull Property<DrawingModel> modelProperty() {
        return this.model;
    }

    private void onClipBoundsChanged(@NonNull Observable observable) {
        this.invalidateHandles();
        this.repaint();
    }

    private void onFigureRemoved(@NonNull Figure figure) {
        this.invalidateHandles();
    }

    private void onRootChanged() {
        this.repaint();
    }

    private void onSubtreeNodesChanged(@NonNull Figure figure) {
        for (Figure f : figure.preorderIterable()) {
            this.dirtyHandles.add(f);
        }
    }

    private void onTreeModelEvent(@NonNull TreeModelEvent<Figure> event) {
        Figure f = (Figure)event.getNode();
        switch (event.getEventType()) {
            case NODE_ADDED_TO_PARENT: 
            case NODE_REMOVED_FROM_TREE: 
            case NODE_ADDED_TO_TREE: {
                break;
            }
            case NODE_REMOVED_FROM_PARENT: {
                this.onFigureRemoved(f);
                break;
            }
            case NODE_CHANGED: {
                this.onNodeChanged(f);
                break;
            }
            case ROOT_CHANGED: {
                this.onRootChanged();
                break;
            }
            case SUBTREE_NODES_CHANGED: {
                this.onSubtreeNodesChanged(f);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(event.getEventType()) + " not supported");
            }
        }
    }

    private void onNodeChanged(Figure f) {
        if (this.selectedFigures.contains((Object)f)) {
            this.dirtyHandles.add(f);
            this.revalidateHandles();
        }
    }

    public void recreateHandles() {
        this.handlesAreValid = false;
        this.recreateHandles = true;
        this.repaint();
    }

    public void repaint() {
        if (this.repainter == null) {
            this.repainter = () -> {
                this.repainter = null;
                this.validateHandles();
            };
            Platform.runLater((Runnable)this.repainter);
        }
    }

    @NonNull ReadOnlySetProperty<Figure> selectedFiguresProperty() {
        return this.selectedFigures;
    }

    public void setDrawingView(@NonNull DrawingView newValue) {
        this.drawingView.set((Object)newValue);
    }

    private void updateHandles() {
        if (this.recreateHandles) {
            for (Map.Entry entry : this.handles.entrySet()) {
                for (Handle h : (List)entry.getValue()) {
                    h.dispose();
                }
            }
            this.nodeToHandleMap.clear();
            this.handles.clear();
            this.handlesPane.getChildren().clear();
            this.dirtyHandles.clear();
            this.createHandles(this.handles);
            this.handlesView.clear();
            for (List list : this.handles.values()) {
                this.handlesView.addAll((Collection)list);
            }
            this.recreateHandles = false;
            for (Map.Entry entry : this.handles.entrySet()) {
                for (Handle handle : (List)entry.getValue()) {
                    Node n = handle.getNode(this.getDrawingViewNonNull());
                    if (this.nodeToHandleMap.put(n, handle) == null) {
                        this.handlesPane.getChildren().add((Object)n);
                        n.applyCss();
                    }
                    handle.updateNode(this.getDrawingViewNonNull());
                }
            }
        } else {
            Figure[] copyOfDirtyHandles = this.dirtyHandles.toArray(new Figure[0]);
            this.dirtyHandles.clear();
            for (Figure f : copyOfDirtyHandles) {
                List hh = (List)this.handles.get(f);
                if (hh == null) continue;
                for (Handle h : hh) {
                    h.updateNode(this.getDrawingViewNonNull());
                }
            }
        }
        for (Handle handle : this.secondaryHandles) {
            handle.updateNode(this.getDrawingViewNonNull());
        }
    }

    private void validateHandles() {
        if (!this.handlesAreValid) {
            this.handlesAreValid = true;
            this.updateHandles();
        }
    }

    public void setSelectedFigures(@NonNull ObservableSet<Figure> selectedFigures) {
        this.selectedFigures.set(selectedFigures);
    }

    public @NonNull ReadOnlySetProperty<Handle> handlesProperty() {
        return this.handlesProperty.getReadOnlyProperty();
    }
}

