/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.render;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Border;
import javafx.scene.layout.Region;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;

public class NodeFinder {
    private static final double LINE45DEG = Math.sqrt(0.5);

    public @Nullable Double contains(@NonNull Node node, @NonNull Point2D pointInLocal, double radiusInLocal) {
        Shape shape;
        double toleranceInLocal = radiusInLocal / FXTransforms.deltaTransform((Transform)node.getLocalToSceneTransform(), (double)LINE45DEG, (double)LINE45DEG).magnitude();
        if (!node.isVisible()) {
            return null;
        }
        Node nodeClip = node.getClip();
        if (nodeClip instanceof javafx.scene.shape.Shape && !(shape = FXShapes.awtShapeFromFX((javafx.scene.shape.Shape)((javafx.scene.shape.Shape)nodeClip))).intersects(pointInLocal.getX() - toleranceInLocal, pointInLocal.getY() - toleranceInLocal, toleranceInLocal * 2.0, toleranceInLocal * 2.0)) {
            return null;
        }
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{javafx.scene.shape.Shape.class, Group.class, Region.class}, (Object)node3, n)) {
            case 0: {
                double widthFactor;
                javafx.scene.shape.Shape shape2 = (javafx.scene.shape.Shape)node3;
                if (shape2.contains(pointInLocal)) {
                    return 0.0;
                }
                switch (shape2.getStrokeType()) {
                    default: {
                        double d = 0.5;
                        break;
                    }
                    case INSIDE: {
                        double d = 0.0;
                        break;
                    }
                    case OUTSIDE: {
                        double d = widthFactor = 1.0;
                    }
                }
                if (FXRectangles.contains((Bounds)shape2.getBoundsInLocal(), (Point2D)pointInLocal, (double)toleranceInLocal)) {
                    int cap = switch (shape2.getStrokeLineCap()) {
                        default -> throw new MatchException(null, null);
                        case StrokeLineCap.SQUARE -> 2;
                        case StrokeLineCap.BUTT -> {
                            if (toleranceInLocal > 0.0) {
                                yield 1;
                            }
                            yield 0;
                        }
                        case StrokeLineCap.ROUND -> 1;
                    };
                    int join = switch (shape2.getStrokeLineJoin()) {
                        default -> throw new MatchException(null, null);
                        case StrokeLineJoin.MITER -> 0;
                        case StrokeLineJoin.BEVEL -> 2;
                        case StrokeLineJoin.ROUND -> 1;
                    };
                    Shape awtShape = FXShapes.awtShapeFromFX((javafx.scene.shape.Shape)shape2);
                    return new BasicStroke(2.0f * (float)(shape2.getStrokeWidth() * widthFactor + toleranceInLocal), cap, join, (float)shape2.getStrokeMiterLimit()).createStrokedShape(awtShape).contains(new Point2D.Double(pointInLocal.getX(), pointInLocal.getY())) ? Double.valueOf(Points.distanceFromShape((Shape)awtShape, (double)pointInLocal.getX(), (double)pointInLocal.getY())) : null;
                }
                return null;
            }
            case 1: {
                Group group = (Group)node3;
                if (FXRectangles.contains((Bounds)node.getBoundsInLocal(), (Point2D)pointInLocal, (double)toleranceInLocal)) {
                    return this.childContains((Parent)node, pointInLocal, radiusInLocal);
                }
                return null;
            }
            case 2: {
                Region region1 = (Region)node3;
                if (FXRectangles.contains((Bounds)node.getBoundsInLocal(), (Point2D)pointInLocal, (double)toleranceInLocal)) {
                    Region region = (Region)node;
                    Background bg = region.getBackground();
                    Border border = region.getBorder();
                    if ((bg == null || bg.isEmpty()) && (border == null || border.isEmpty())) {
                        return this.childContains((Parent)node, pointInLocal, radiusInLocal);
                    }
                    return 0.0;
                }
                return null;
            }
        }
        return FXRectangles.contains((Bounds)node.getBoundsInLocal(), (Point2D)pointInLocal, (double)radiusInLocal) ? Double.valueOf(0.0) : null;
    }

    private @Nullable Double childContains(@NonNull Parent node, @NonNull Point2D pointInLocal, double tolerance) {
        double minDistance = Double.POSITIVE_INFINITY;
        for (Node child : node.getChildrenUnmodifiable()) {
            Double distance = this.contains(child, child.parentToLocal(pointInLocal), tolerance);
            if (distance == null) continue;
            minDistance = Math.min(minDistance, distance);
        }
        return Double.isFinite(minDistance) ? Double.valueOf(minDistance) : null;
    }

    public @Nullable Node findNodeRecursive(@NonNull Node n, double vx, double vy, double radius) {
        if (this.contains(n, new Point2D(vx, vy), radius) != null) {
            if (n instanceof javafx.scene.shape.Shape) {
                return n;
            }
            if (n instanceof Group) {
                Group group = (Group)n;
                Point2D pl = n.parentToLocal(vx, vy);
                ObservableList children = group.getChildren();
                for (int i = children.size() - 1; i >= 0; --i) {
                    Node child = (Node)children.get(i);
                    double radiusInChild = child.parentToLocal(radius, 0.0).magnitude();
                    Node found = this.findNodeRecursive(child, pl.getX(), pl.getY(), radiusInChild);
                    if (found == null) continue;
                    return found;
                }
            }
        }
        return null;
    }
}

