/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Line;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.key.NonNullObjectStyleableKey;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractCreationTool;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.PolylineToCubicCurve;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jhotdraw8.geom.shape.BezierPathBuilder;

public class BezierCreationTool
extends AbstractCreationTool<Figure> {
    private int dragStartIndex;
    private final NonNullObjectStyleableKey<BezierPath> key;
    private @Nullable BezierPath path;
    private final @NonNull Line rubberBand = new Line();

    public BezierCreationTool(String name, Resources rsrc, NonNullObjectStyleableKey<BezierPath> key, Supplier<Figure> factory) {
        this(name, rsrc, key, factory, LayerFigure::new);
    }

    public BezierCreationTool(String name, Resources rsrc, NonNullObjectStyleableKey<BezierPath> key, Supplier<Figure> figureFactory, Supplier<Layer> layerFactory) {
        super(name, rsrc, figureFactory, layerFactory);
        this.key = key;
        this.node.setCursor(Cursor.CROSSHAIR);
        this.rubberBand.setVisible(false);
        this.rubberBand.setMouseTransparent(true);
        this.rubberBand.getStrokeDashArray().setAll((Object[])new Double[]{2.0, 5.0});
        this.rubberBand.setManaged(false);
        this.node.getChildren().add((Object)this.rubberBand);
    }

    @Override
    public void activate(@NonNull DrawingEditor editor) {
        this.requestFocus();
        this.rubberBand.setVisible(false);
        this.createdFigure = null;
        super.activate(editor);
    }

    @Override
    protected void onMouseClicked(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (event.getClickCount() > 1 && this.createdFigure != null) {
            for (int i = this.path.size() - 1; i > 0; --i) {
                if (!Objects.equals(this.path.get(i), this.path.get(i - 1))) continue;
                this.path = this.path.removeAt(i);
            }
            DrawingModel dm = dv.getModel();
            if (this.path.size() < 2) {
                dm.removeFromParent(this.createdFigure);
            } else {
                dm.set(this.createdFigure, this.key, this.path);
                dv.getSelectedFigures().clear();
                dv.getEditor().setHandleType(HandleType.POINT);
                dv.getSelectedFigures().add((Object)this.createdFigure);
            }
            this.createdFigure = null;
            this.path = null;
            this.fireToolDone();
        }
    }

    @Override
    protected void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.createdFigure != null && this.path != null) {
            double x2 = event.getX();
            double y2 = event.getY();
            Point2D c2 = this.createdFigure.worldToParent(dv.viewToWorld(x2, y2));
            DrawingModel dm = dv.getModel();
            if (this.dragStartIndex < 0) {
                this.path = this.path.add(new BezierNode(c2.getX(), c2.getY()));
                this.dragStartIndex = this.path.size() - 1;
            } else {
                this.path = this.path.add(new BezierNode(c2.getX(), c2.getY()));
            }
            dm.set(this.createdFigure, this.key, this.path);
        }
        event.consume();
    }

    @Override
    protected void onMouseMoved(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.createdFigure != null && this.path != null && !this.path.isEmpty()) {
            BezierNode lastNode = this.path.get(this.path.size() - 1);
            Point2D start = FXTransforms.transform((Transform)FXTransforms.concat((Transform[])new Transform[]{dv.getWorldToView(), this.createdFigure.getLocalToWorld()}), (double)lastNode.pointX(), (double)lastNode.pointY());
            this.rubberBand.setStartX(start.getX());
            this.rubberBand.setStartY(start.getY());
            this.rubberBand.setEndX(event.getX());
            this.rubberBand.setEndY(event.getY());
            this.rubberBand.setVisible(true);
        }
        event.consume();
    }

    @Override
    protected void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.getClickCount() != 1) {
            return;
        }
        double x1 = event.getX();
        double y1 = event.getY();
        DrawingModel dm = view.getModel();
        if (this.createdFigure == null) {
            Figure parent;
            this.createdFigure = this.createFigure();
            Figure figure = parent = this.createdFigure == null ? null : this.getOrCreateParent(view, this.createdFigure);
            if (parent == null) {
                this.createdFigure = null;
                this.path = null;
                return;
            }
            this.path = BezierPath.of();
            view.setActiveParent(parent);
            dm.addChildTo(this.createdFigure, parent);
        }
        assert (this.path != null);
        CssPoint2D c = view.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(view.viewToWorld(new Point2D(x1, y1)))));
        this.path = this.path.add(new BezierNode(c.getConvertedValue()));
        dm.set(this.createdFigure, this.key, this.path);
        this.rubberBand.setVisible(false);
        this.dragStartIndex = -1;
        event.consume();
    }

    @Override
    protected void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.createdFigure == null || this.path == null) {
            return;
        }
        if (this.dragStartIndex != -1) {
            int i;
            ArrayList<Point2D> digitized = new ArrayList<Point2D>(this.path.size() - this.dragStartIndex);
            int n = this.path.size();
            for (int i2 = this.dragStartIndex; i2 < n; ++i2) {
                digitized.add((Point2D)this.path.get(i2).getPoint(Point2D::new));
            }
            BezierPathBuilder builder = new BezierPathBuilder();
            double error = 5.0 / dv.getZoomFactor();
            PolylineToCubicCurve.fitBezierPath((PathBuilder)builder, digitized, (double)error);
            BezierPath built = builder.build();
            BezierPath newList = BezierPath.of();
            for (i = 0; i < this.dragStartIndex; ++i) {
                newList = newList.add(this.path.get(i));
            }
            int n2 = built.size();
            for (i = 0; i < n2; ++i) {
                newList = i == 0 ? newList.add(built.get(i).withMask(built.get(i).getMask() & 0xFFFFFFF7)) : newList.add(built.get(i));
            }
            this.path = newList = newList.add((BezierNode)this.path.getLast());
            DrawingModel dm = dv.getModel();
            dm.set(this.createdFigure, this.key, this.path);
            this.dragStartIndex = -1;
        }
    }

    @Override
    protected void stopEditing() {
        if (this.createdFigure != null) {
            this.rubberBand.setVisible(false);
            this.createdFigure = null;
            this.path = null;
        }
    }

    @Override
    public @NonNull String getHelpText() {
        return "BezierCreationTool\n  Click on the drawing view. The tool will create a new bezier curve with a point at that location.\n  Continue clicking on the drawing view. The tool will add each clicked point to the created bezier curve.\n  Press enter or escape, when you are done.\nOr\n  Press and drag the mouse over the drawing view to draw a curve. The tool will create a new bezier curve with a curve fitted to your drawing.\n  Continue pressing and dragging on the drawing view. The tool will add additional fitted curves to the bezier curve.\n  Press enter or escape when you are done.";
    }
}

