/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.controls.urichooser.FileURIChooser;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.ImageFigure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.tool.CreationTool;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class ImageCreationTool
extends CreationTool {
    private final @NonNull MapAccessor<URI> uriKey = ImageFigure.IMAGE_URI;
    private URIChooser uriChooser;
    private @Nullable URI uri;
    private Future<Dimension2D> dimensionFuture;

    public ImageCreationTool(String name, Resources rsrc, Supplier<Figure> supplier, Supplier<Layer> layerFactory) {
        super(name, rsrc, (Supplier<? extends Figure>)supplier, layerFactory);
    }

    @Override
    public void activate(@NonNull DrawingEditor editor) {
        super.activate(editor);
        Map.Entry<URI, Future<Dimension2D>> entry = this.chooseFile();
        if (entry != null) {
            this.uri = entry.getKey();
            this.dimensionFuture = entry.getValue();
        } else {
            this.uri = null;
            this.dimensionFuture = null;
        }
    }

    @Override
    protected Figure createFigure() {
        Object f = super.createFigure();
        f.set(this.uriKey, (Object)this.uri);
        return f;
    }

    @Override
    public double getDefaultHeight() {
        Dimension2D dim = this.getDefaultDimensionFromImage();
        return dim != null ? dim.getHeight() : super.getDefaultHeight();
    }

    private @Nullable Dimension2D getDefaultDimensionFromImage() {
        if (this.dimensionFuture != null) {
            try {
                return this.dimensionFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public double getDefaultWidth() {
        Dimension2D dim = this.getDefaultDimensionFromImage();
        return dim != null ? dim.getWidth() : super.getDefaultWidth();
    }

    protected @NonNull URIChooser createURIChooser() {
        FileURIChooser c = new FileURIChooser();
        c.setMode(FileURIChooser.Mode.OPEN);
        c.getFileChooser().getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Image", new String[]{"*.bmp", "*.gif", "*.jpg", "*.png"}));
        return c;
    }

    protected  @Nullable Map.Entry<URI, Future<Dimension2D>> chooseFile() {
        if (this.uriChooser == null) {
            this.uriChooser = this.createURIChooser();
        }
        URI uri = this.uriChooser.showDialog((Node)this.node);
        return new AbstractMap.SimpleImmutableEntry<URI, Future<Dimension2D>>(uri, this.readImageSize(uri));
    }

    private Future<Dimension2D> readImageSize(URI uri) {
        CompletableFuture<Dimension2D> future = new CompletableFuture<Dimension2D>();
        if (uri == null) {
            future.complete(null);
        } else {
            new Thread(() -> {
                block13: {
                    Path path = Paths.get(uri);
                    try {
                        Iterator iterator;
                        ImageInputStream in = ImageIO.createImageInputStream(path.toFile());
                        if (in != null && (iterator = ((Iterable)() -> ImageIO.getImageReaders(in)).iterator()).hasNext()) {
                            ImageReader reader = (ImageReader)iterator.next();
                            try {
                                reader.setInput(in);
                                future.complete(new Dimension2D((double)reader.getWidth(0), (double)reader.getHeight(0)));
                                return;
                            }
                            finally {
                                reader.dispose();
                            }
                        }
                        future.complete(null);
                        break block13;
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }).start();
        }
        return future;
    }
}

