/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AnchorableFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.figure.LineFigure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.CreationTool;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public class LineCreationTool
extends CreationTool {
    private final MapAccessor<CssPoint2D> p1;
    private final MapAccessor<CssPoint2D> p2;

    public LineCreationTool(String name, Resources rsrc, Supplier<? extends Figure> factory) {
        this(name, rsrc, factory, LayerFigure::new, (MapAccessor<CssPoint2D>)LineFigure.START, (MapAccessor<CssPoint2D>)LineFigure.END);
    }

    public LineCreationTool(String name, Resources rsrc, Supplier<? extends Figure> factory, MapAccessor<CssPoint2D> p1, MapAccessor<CssPoint2D> p2) {
        this(name, rsrc, factory, LayerFigure::new, p1, p2);
    }

    public LineCreationTool(String name, Resources rsrc, Supplier<? extends Figure> figureFactory, Supplier<Layer> layerFactory) {
        this(name, rsrc, figureFactory, layerFactory, (MapAccessor<CssPoint2D>)LineFigure.START, (MapAccessor<CssPoint2D>)LineFigure.END);
    }

    public LineCreationTool(String name, Resources rsrc, Supplier<? extends Figure> figureFactory, Supplier<Layer> layerFactory, MapAccessor<CssPoint2D> p1, MapAccessor<CssPoint2D> p2) {
        super(name, rsrc, figureFactory, layerFactory);
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    protected void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        Figure parent;
        this.undoHelper.stopCompositeEdit();
        this.x1 = event.getX();
        this.y1 = event.getY();
        this.x2 = this.x1;
        this.y2 = this.y1;
        this.createdFigure = this.createFigure();
        Figure figure = parent = this.createdFigure == null ? null : this.getOrCreateParent(view, this.createdFigure);
        if (parent == null) {
            this.createdFigure = null;
            return;
        }
        this.undoHelper.startCompositeEdit(null);
        DrawingModel dm = view.getModel();
        dm.addChildTo(this.createdFigure, parent);
        double anchorX = MathUtil.clamp((double)((Double)this.createdFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_X)), (double)0.0, (double)1.0);
        double anchorY = MathUtil.clamp((double)((Double)this.createdFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_Y)), (double)0.0, (double)1.0);
        CssPoint2D c = view.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(view.viewToWorld(new Point2D(this.x1, this.y1)))));
        this.createdFigure.set(this.p1, c);
        this.createdFigure.set(this.p2, c);
        Drawing drawing = dm.getDrawing();
        view.setActiveParent(parent);
        event.consume();
    }

    @Override
    protected void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        this.undoHelper.startCompositeEdit(null);
        if (this.createdFigure != null) {
            this.x2 = event.getX();
            this.y2 = event.getY();
            CssPoint2D c1 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1, this.y1))));
            CssPoint2D c2 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x2, this.y2))));
            DrawingModel dm = dv.getModel();
            dm.set(this.createdFigure, this.p1, c1);
            dm.set(this.createdFigure, this.p2, c2);
        }
        event.consume();
    }

    @Override
    protected void reshapeInLocal(@NonNull Figure figure, @NonNull CssPoint2D c1, @NonNull CssPoint2D c2, @NonNull DrawingModel dm) {
        dm.set(figure, this.p1, c1);
        dm.set(figure, this.p2, c2);
    }
}

