/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.key.Point2DListStyleableKey;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractCreationTool;
import org.jhotdraw8.icollection.VectorList;

public class PolyCreationTool
extends AbstractCreationTool<Figure> {
    private @Nullable ArrayList<Point2D> points;
    private final Point2DListStyleableKey key;

    public PolyCreationTool(String name, Resources rsrc, Point2DListStyleableKey key, Supplier<Figure> factory) {
        this(name, rsrc, key, factory, LayerFigure::new);
    }

    public PolyCreationTool(String name, Resources rsrc, Point2DListStyleableKey key, Supplier<Figure> figureFactory, Supplier<Layer> layerFactory) {
        super(name, rsrc, figureFactory, layerFactory);
        this.key = key;
        this.node.setCursor(Cursor.CROSSHAIR);
    }

    @Override
    protected void stopEditing() {
        if (this.createdFigure != null) {
            this.createdFigure = null;
            this.points = null;
        }
    }

    @Override
    protected void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (event.getClickCount() != 1) {
            return;
        }
        double x1 = event.getX();
        double y1 = event.getY();
        DrawingModel dm = view.getModel();
        if (this.createdFigure == null) {
            Figure parent;
            this.createdFigure = this.createFigure();
            Figure figure = parent = this.createdFigure == null ? null : this.getOrCreateParent(view, this.createdFigure);
            if (parent == null) {
                this.createdFigure = null;
                this.points = null;
                event.consume();
                return;
            }
            dm.addChildTo(this.createdFigure, parent);
            this.points = new ArrayList();
            Point2D c = view.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(view.viewToWorld(new Point2D(x1, y1))))).getConvertedValue();
            this.points.add(c);
            this.points.add(c);
            view.setActiveParent(parent);
        } else {
            assert (this.points != null);
            Point2D c = view.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(view.viewToWorld(new Point2D(x1, y1))))).getConvertedValue();
            this.points.add(c);
        }
        dm.set(this.createdFigure, this.key, VectorList.copyOf(this.points));
        event.consume();
    }

    @Override
    protected void onMouseMoved(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.createdFigure != null) {
            this.onMouseDragged(event, dv);
        }
    }

    @Override
    protected void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.createdFigure != null && this.points != null) {
            double x2 = event.getX();
            double y2 = event.getY();
            Point2D c2 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(x2, y2)))).getConvertedValue();
            DrawingModel dm = dv.getModel();
            this.points.set(this.points.size() - 1, c2);
            dm.set(this.createdFigure, this.key, VectorList.copyOf(this.points));
        }
        event.consume();
    }

    @Override
    protected void onMouseClicked(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (event.getClickCount() > 1 && this.createdFigure != null && this.points != null) {
            for (int i = this.points.size() - 1; i > 0; --i) {
                if (!Objects.equals(this.points.get(i), this.points.get(i - 1))) continue;
                this.points.remove(i);
            }
            DrawingModel dm = dv.getModel();
            if (this.points.size() < 2) {
                dm.removeFromParent(this.createdFigure);
            } else {
                dm.set(this.createdFigure, this.key, VectorList.copyOf(this.points));
                dv.getSelectedFigures().clear();
                dv.getEditor().setHandleType(HandleType.POINT);
                dv.getSelectedFigures().add((Object)this.createdFigure);
            }
            this.createdFigure = null;
            this.points = null;
            this.fireToolDone();
        }
    }

    @Override
    public void activate(@NonNull DrawingEditor editor) {
        this.requestFocus();
        super.activate(editor);
        this.createdFigure = null;
    }

    @Override
    public @NonNull String getHelpText() {
        return "PolyCreationTool\n  Click on the drawing view. The tool will create a new polygon with a point at that location.\n  Continue clicking on the drawing view. The tool will add each clicked point to the created polygon.\n  Press enter or escape, when you are done.";
    }
}

