/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Cursor;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ZoomEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.tool.AbstractTool;
import org.jhotdraw8.draw.tool.DragTracker;
import org.jhotdraw8.draw.tool.HandleTracker;
import org.jhotdraw8.draw.tool.SelectAreaTracker;
import org.jhotdraw8.draw.tool.SimpleDragTracker;
import org.jhotdraw8.draw.tool.SimpleHandleTracker;
import org.jhotdraw8.draw.tool.SimpleSelectAreaTracker;
import org.jhotdraw8.draw.tool.Tracker;

public class SelectionTool
extends AbstractTool {
    public static final String ID = "tool.selectFigure";
    public static final String SELECT_BEHIND_ENABLED = "selectBehindEnabled";
    private @Nullable Tracker tracker;
    private HandleTracker handleTracker;
    private SelectAreaTracker selectAreaTracker;
    private DragTracker dragTracker;
    private final boolean updateCursor = true;
    private final BooleanProperty selectBehindEnabled = new SimpleBooleanProperty((Object)this, "selectBehindEnabled", true);
    private boolean mouseDragged;
    private @Nullable Figure pressedFigure;
    private final HandleType handleType;
    private HandleType leadHandleType;
    private HandleType anchorHandleType;
    double zoomFactor = 1.0;

    public SelectionTool() {
        this(ID, HandleType.RESIZE, ApplicationLabels.getResources());
    }

    public SelectionTool(String name, Resources rsrc) {
        this(name, HandleType.RESIZE, rsrc);
    }

    public SelectionTool(String name, HandleType handleType, Resources rsrc) {
        super(name, rsrc);
        this.handleType = handleType;
    }

    public SelectionTool(String name, HandleType handleType, HandleType anchorHandleType, HandleType leadHandleType, Resources rsrc) {
        super(name, rsrc);
        this.handleType = handleType;
        this.anchorHandleType = anchorHandleType;
        this.leadHandleType = leadHandleType;
    }

    public @NonNull BooleanProperty selectBehindEnabledProperty() {
        return this.selectBehindEnabled;
    }

    @Override
    protected void stopEditing() {
        this.setTracker(null);
    }

    @Override
    protected void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.requestFocus();
        this.mouseDragged = false;
        double vx = event.getX();
        double vy = event.getY();
        Handle h = view.findHandle(vx, vy);
        if (h != null) {
            this.node.setCursor(h.getCursor());
            this.setTracker(this.getHandleTracker(h));
        } else {
            this.node.setCursor(Cursor.DEFAULT);
            this.tracker = null;
        }
        if (this.tracker == null) {
            if (event.isControlDown()) {
                SelectAreaTracker t = this.getSelectAreaTracker();
                this.setTracker(t);
            } else {
                if (this.isSelectBehindEnabled() && event.isAltDown()) {
                    this.pressedFigure = null;
                    Figure firstFigure = null;
                    boolean selectionFound = false;
                    for (Map.Entry<Figure, Double> e : view.findFigures(vx, vy, false)) {
                        Figure f = e.getKey();
                        if (f.isShowing() && firstFigure == null) {
                            firstFigure = f;
                        }
                        if (view.selectedFiguresProperty().contains((Object)f)) {
                            selectionFound = true;
                            continue;
                        }
                        if (!selectionFound) continue;
                        this.pressedFigure = f;
                        break;
                    }
                    if (this.pressedFigure == null) {
                        this.pressedFigure = firstFigure;
                    }
                } else {
                    this.pressedFigure = view.findFigure(vx, vy, (Set<Figure>)view.getSelectedFigures());
                    if (this.pressedFigure == null) {
                        this.pressedFigure = view.findFigure(vx, vy);
                    }
                }
                if (event.isShiftDown() && !event.isMetaDown()) {
                    if (this.pressedFigure != null) {
                        if (view.getSelectedFigures().contains((Object)this.pressedFigure)) {
                            view.getSelectedFigures().remove((Object)this.pressedFigure);
                        } else {
                            view.getSelectedFigures().add((Object)this.pressedFigure);
                        }
                        return;
                    }
                } else {
                    if (!event.isShiftDown() && event.isMetaDown()) {
                        return;
                    }
                    if (event.isShiftDown() && event.isMetaDown()) {
                        if (this.pressedFigure != null) {
                            view.selectedFiguresProperty().clear();
                            view.selectedFiguresProperty().add((Object)this.pressedFigure);
                        }
                    } else if (!(event.isShiftDown() || event.isMetaDown() || this.pressedFigure == null || view.selectedFiguresProperty().contains((Object)this.pressedFigure))) {
                        view.selectedFiguresProperty().clear();
                        view.selectedFiguresProperty().add((Object)this.pressedFigure);
                    }
                }
                if (view.selectedFiguresProperty().contains((Object)this.pressedFigure)) {
                    t = this.getDragTracker(this.pressedFigure, view);
                    this.setTracker(t);
                } else {
                    t = this.getSelectAreaTracker();
                    this.setTracker(t);
                }
            }
        }
        if (this.tracker != null) {
            this.tracker.trackMousePressed(event, view);
        }
        this.fireToolStarted();
    }

    @Override
    protected void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        this.mouseDragged = true;
        if (this.tracker != null) {
            this.tracker.trackMouseDragged(event, dv);
        }
    }

    @Override
    protected void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.tracker != null) {
            this.tracker.trackMouseReleased(event, dv);
        }
    }

    @Override
    protected void onMouseClicked(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.tracker != null) {
            this.tracker.trackMouseClicked(event, dv);
        }
    }

    @Override
    protected void onMouseMoved(@NonNull MouseEvent event, @NonNull DrawingView view) {
        double vy;
        double vx = event.getX();
        Handle h = view.findHandle(vx, vy = event.getY());
        if (h != null) {
            this.node.setCursor(h.getCursor());
        } else {
            this.node.setCursor(Cursor.DEFAULT);
        }
    }

    @Override
    protected void onKeyPressed(@NonNull KeyEvent event, @NonNull DrawingView view) {
        if (this.tracker != null) {
            this.tracker.trackKeyPressed(event, view);
        }
    }

    @Override
    protected void onKeyReleased(@NonNull KeyEvent event, @NonNull DrawingView view) {
        if (this.tracker != null) {
            this.tracker.trackKeyReleased(event, view);
        }
    }

    @Override
    protected void onKeyTyped(@NonNull KeyEvent event, @NonNull DrawingView view) {
        if (this.tracker != null) {
            this.tracker.trackKeyTyped(event, view);
        }
    }

    protected HandleTracker getHandleTracker(Handle handle) {
        if (this.handleTracker == null) {
            this.handleTracker = new SimpleHandleTracker();
        }
        this.handleTracker.setHandles(handle, this.getDrawingView().getFiguresWithCompatibleHandle((Collection<Figure>)this.getDrawingView().getSelectedFigures(), handle));
        return this.handleTracker;
    }

    protected DragTracker getDragTracker(Figure f, DrawingView dv) {
        if (this.dragTracker == null) {
            this.dragTracker = new SimpleDragTracker();
        }
        this.dragTracker.setDraggedFigure(f, dv);
        return this.dragTracker;
    }

    protected SelectAreaTracker getSelectAreaTracker() {
        if (this.selectAreaTracker == null) {
            this.selectAreaTracker = new SimpleSelectAreaTracker();
        }
        return this.selectAreaTracker;
    }

    public void setHandleTracker(HandleTracker newValue) {
        this.handleTracker = newValue;
    }

    public void setSelectAreaTracker(SelectAreaTracker newValue) {
        this.selectAreaTracker = newValue;
    }

    public void setDragTracker(DragTracker newValue) {
        this.dragTracker = newValue;
    }

    private void setTracker(Tracker t) {
        if (this.tracker != null) {
            this.drawPane.setCenter(null);
            this.node.cursorProperty().unbindBidirectional((Property)this.tracker.getNode().cursorProperty());
        }
        this.tracker = t;
        if (this.tracker != null) {
            this.drawPane.setCenter(this.tracker.getNode());
            this.node.cursorProperty().bindBidirectional((Property)this.tracker.getNode().cursorProperty());
            this.node.setCursor(Cursor.DEFAULT);
        }
    }

    @Override
    public void activate(@NonNull DrawingEditor editor) {
        for (DrawingView view : editor.getDrawingViews()) {
            view.getEditor().setHandleType(this.handleType);
            view.getEditor().setAnchorHandleType(this.anchorHandleType);
            view.getEditor().setLeadHandleType(this.leadHandleType);
        }
        this.requestFocus();
        super.activate(editor);
    }

    public boolean isSelectBehindEnabled() {
        return this.selectBehindEnabled.get();
    }

    @Override
    protected void onZoom(@NonNull ZoomEvent event, @NonNull DrawingView dv) {
        dv.setZoomFactor(this.zoomFactor * event.getTotalZoomFactor());
    }

    @Override
    protected void onZoomStarted(@NonNull ZoomEvent event, @NonNull DrawingView dv) {
        this.zoomFactor = dv.getZoomFactor();
    }

    @Override
    public @NonNull String getHelpText() {
        return "SelectionTool\n  Click on the drawing view. The tool will select the figure at that location.\nOr:\n  Alt+Click on the drawing view. The tool will select the figure behind the currently selected figure at that location.\nOr:\n  Shift+Click on the drawing view. The tool will toggle the figure at that location to/from the selection.\nOr:\n  Shift+Command+Click on the drawing view. The tool will deselect all figures except the figure that is on that location.\nOr:\n  Press and drag the mouse over the drawing view to draw the diagonal of a rectangle. The tool will select all figures that fit into the rectangle.";
    }
}

