/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.StreamSupport;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AnchorableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractTracker;
import org.jhotdraw8.draw.tool.DragTracker;
import org.jhotdraw8.fxbase.undo.CompositeEdit;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.graph.iterator.BfsDfsVertexSpliterator;

public class SimpleDragTracker
extends AbstractTracker
implements DragTracker {
    private @Nullable Set<Figure> groupReshapeableFigures;
    private @Nullable Figure anchorFigure;
    private @Nullable CssPoint2D oldPoint;
    private @Nullable CssPoint2D anchor;
    private @Nullable CompositeEdit undoableEdit;

    @Override
    public void setDraggedFigure(Figure anchor, @NonNull DrawingView view) {
        this.anchorFigure = anchor;
        ObservableSet<Figure> selectedFigures = view.getSelectedFigures();
        this.groupReshapeableFigures = new HashSet<Figure>();
        for (Figure f : selectedFigures) {
            if (!f.isGroupReshapeableWith((Set<Figure>)selectedFigures)) continue;
            this.groupReshapeableFigures.add(f);
        }
    }

    private boolean dependsOn(@NonNull Figure f, @NonNull Set<Figure> others) {
        return StreamSupport.stream(new BfsDfsVertexSpliterator(Figure::getLayoutSubjects, (Object)f, false), false).anyMatch(fg -> fg != f && others.contains(fg) || fg.getParent() != null && this.containsAny(others, fg.getParent().getPath()));
    }

    private <E> boolean containsAny(@NonNull Collection<E> subject, @NonNull Collection<E> c) {
        for (E e : c) {
            if (!subject.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trackMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.stopCompositeEdit(view);
        this.oldPoint = this.anchor = view.getConstrainer().constrainPoint(this.anchorFigure, new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY()))));
    }

    @Override
    public void trackMouseReleased(MouseEvent event, @NonNull DrawingView dv) {
        dv.recreateHandles();
        this.stopCompositeEdit(dv);
    }

    @Override
    public void trackMouseClicked(MouseEvent event, DrawingView dv) {
        this.stopCompositeEdit(dv);
    }

    @Override
    public void trackMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.startCompositeEdit(view);
        CssPoint2D newPoint = new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.anchorFigure, newPoint);
        }
        if (event.isMetaDown()) {
            Bounds bounds = this.anchorFigure.getLayoutBounds();
            double anchorX = MathUtil.clamp((double)((Double)this.anchorFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_X)), (double)0.0, (double)1.0);
            double anchorY = MathUtil.clamp((double)((Double)this.anchorFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_Y)), (double)0.0, (double)1.0);
            Point2D loc = new Point2D(bounds.getMinX() + anchorX * bounds.getWidth(), bounds.getMinY() + anchorY * bounds.getHeight());
            this.oldPoint = new CssPoint2D(this.anchorFigure.localToWorld(loc));
        }
        if (newPoint.equals(this.oldPoint)) {
            return;
        }
        DrawingModel model = view.getModel();
        if (event.isShiftDown()) {
            Figure f = this.anchorFigure;
            MoveHandle.translateFigure(f, this.oldPoint, newPoint, model);
        } else {
            for (Figure f : this.groupReshapeableFigures) {
                MoveHandle.translateFigure(f, this.oldPoint, newPoint, model);
            }
        }
        this.oldPoint = newPoint;
    }

    @Override
    public void trackKeyPressed(KeyEvent event, DrawingView view) {
        CssPoint2D translate = null;
        if (event.getEventType() == KeyEvent.KEY_PRESSED) {
            switch (event.getCode()) {
                case UP: {
                    CssPoint2D cssPoint2D = new CssPoint2D(0.0, -1.0);
                    break;
                }
                case DOWN: {
                    CssPoint2D cssPoint2D = new CssPoint2D(0.0, 1.0);
                    break;
                }
                case LEFT: {
                    CssPoint2D cssPoint2D = new CssPoint2D(-1.0, 0.0);
                    break;
                }
                case RIGHT: {
                    CssPoint2D cssPoint2D = new CssPoint2D(1.0, 0.0);
                    break;
                }
                default: {
                    CssPoint2D cssPoint2D = translate = null;
                }
            }
        }
        if (translate != null) {
            event.consume();
            DrawingModel model = view.getModel();
            for (Figure f : view.getSelectedFigures()) {
                model.translateInParent(f, translate);
            }
        }
    }

    @Override
    public void trackKeyReleased(KeyEvent event, DrawingView view) {
    }

    @Override
    public void trackKeyTyped(KeyEvent event, DrawingView view) {
    }
}

