/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TextEditableFigure;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractTool;

public class TextEditingTool
extends AbstractTool {
    private double defaultWidth = 100.0;
    private double defaultHeight = 100.0;
    private final @NonNull TextArea textArea = new TextArea();
    private @Nullable TextEditableFigure.TextEditorData editorData;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private final double minSize = 2.0;

    public TextEditingTool(String id, Resources labels) {
        super(id, labels);
        this.node.setCursor(Cursor.CROSSHAIR);
        this.textArea.setWrapText(true);
        this.textArea.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                keyEvent.consume();
                this.stopEditing();
            }
        });
    }

    public double getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(double defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public double getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(double defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    protected void stopEditing() {
        if (this.editorData != null) {
            this.node.getChildren().remove((Object)this.textArea);
            DrawingView drawingView = this.getDrawingView();
            if (drawingView != null) {
                DrawingModel model = drawingView.getModel();
                model.set(this.editorData.figure(), this.editorData.textKey(), this.textArea.getText());
            }
            this.editorData = null;
        }
    }

    @Override
    protected void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        TextEditableFigure f2;
        TextEditableFigure.TextEditorData data;
        event.consume();
        if (this.editorData != null) {
            this.stopEditing();
            return;
        }
        this.x1 = event.getX();
        this.y1 = event.getY();
        Figure figure = view.findFigure(this.x1, this.y1, f -> f.isSelectable() && f instanceof TextEditableFigure);
        if (figure instanceof TextEditableFigure && (data = (f2 = (TextEditableFigure)figure).getTextEditorDataFor(f2.worldToLocal(new Point2D(this.x1, this.y1)), view.findFigureNode(f2, this.x1, this.y1))) != null) {
            this.startEditing(data, view);
        }
    }

    private void startEditing(@NonNull TextEditableFigure.TextEditorData data, @NonNull DrawingView dv) {
        dv.getSelectedFigures().clear();
        dv.getEditor().setHandleType(HandleType.SELECT);
        dv.getSelectedFigures().add((Object)data.figure());
        this.editorData = data;
        this.textArea.setManaged(false);
        this.node.getChildren().add((Object)this.textArea);
        Bounds bounds = dv.worldToView(data.figure().localToWorld(data.boundsInLocal()));
        this.textArea.resizeRelocate(bounds.getMinX(), bounds.getMinY(), Math.max(80.0, Math.max(this.textArea.getMinWidth(), bounds.getWidth())), Math.max(40.0, Math.max(this.textArea.getMinHeight(), bounds.getHeight())));
        this.textArea.setText((String)data.figure().get(this.editorData.textKey()));
        this.textArea.requestFocus();
    }

    @Override
    protected void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        if (this.editorData != null) {
            // empty if block
        }
    }

    @Override
    protected void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        event.consume();
        if (this.editorData != null) {
            // empty if block
        }
    }

    @Override
    protected void onMouseMoved(@NonNull MouseEvent event, @NonNull DrawingView view) {
        TextEditableFigure f;
        TextEditableFigure.TextEditorData data;
        if (this.editorData != null) {
            return;
        }
        Figure figure = view.findFigure(event.getX(), event.getY());
        if (figure instanceof TextEditableFigure && (data = (f = (TextEditableFigure)figure).getTextEditorDataFor(f.getWorldToLocal().transform(event.getX(), event.getY()), view.findFigureNode(f, event.getX(), event.getY()))) != null) {
            this.node.setCursor(Cursor.TEXT);
            return;
        }
        this.node.setCursor(Cursor.CROSSHAIR);
    }

    @Override
    public void activate(@NonNull DrawingEditor editor) {
        this.requestFocus();
        super.activate(editor);
    }

    @Override
    public @NonNull String getHelpText() {
        return "CreationTool\n  Click on the drawing view. The tool will create a new figure with default size at the clicked location.\nOr:\n  Press and drag the mouse over the drawing view to define the diagonal of a rectangle. The tool will create a new figure that fits into the rectangle.";
    }
}

