/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;

public class TreeModelEventUndoableEdit<T>
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 0L;
    private final @NonNull TreeModelEvent<T> event;

    public TreeModelEventUndoableEdit(@NonNull TreeModelEvent<T> event) {
        this.event = event;
    }

    @Override
    public void undo() throws CannotUndoException {
        switch (this.event.getEventType()) {
            case ROOT_CHANGED: {
                ((TreeModel)this.event.getSource()).setRoot(this.event.getOldRoot());
                break;
            }
            case SUBTREE_NODES_CHANGED: 
            case NODE_CHANGED: 
            case NODE_REMOVED_FROM_TREE: 
            case NODE_ADDED_TO_TREE: {
                break;
            }
            case NODE_ADDED_TO_PARENT: {
                ((TreeModel)this.event.getSource()).removeFromParent(this.event.getChild());
                break;
            }
            case NODE_REMOVED_FROM_PARENT: {
                ((TreeModel)this.event.getSource()).insertChildAt(this.event.getChild(), this.event.getParent(), this.event.getChildIndex());
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        switch (this.event.getEventType()) {
            case ROOT_CHANGED: {
                ((TreeModel)this.event.getSource()).setRoot(this.event.getNewRoot());
                break;
            }
            case SUBTREE_NODES_CHANGED: 
            case NODE_CHANGED: 
            case NODE_REMOVED_FROM_TREE: 
            case NODE_ADDED_TO_TREE: {
                break;
            }
            case NODE_ADDED_TO_PARENT: {
                ((TreeModel)this.event.getSource()).insertChildAt(this.event.getChild(), this.event.getParent(), this.event.getChildIndex());
                break;
            }
            case NODE_REMOVED_FROM_PARENT: {
                ((TreeModel)this.event.getSource()).removeFromParent(this.event.getChild());
            }
        }
    }

    @Override
    public boolean isSignificant() {
        return switch (this.event.getEventType()) {
            default -> throw new MatchException(null, null);
            case TreeModelEvent.EventType.ROOT_CHANGED, TreeModelEvent.EventType.NODE_ADDED_TO_PARENT, TreeModelEvent.EventType.NODE_REMOVED_FROM_PARENT -> true;
            case TreeModelEvent.EventType.SUBTREE_NODES_CHANGED, TreeModelEvent.EventType.NODE_CHANGED, TreeModelEvent.EventType.NODE_REMOVED_FROM_TREE, TreeModelEvent.EventType.NODE_ADDED_TO_TREE -> false;
        };
    }

    @Override
    public String getPresentationName() {
        return "Tree Structure";
    }
}

