/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.List;
import javafx.scene.shape.PathElement;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.geom.FXSvgPaths;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class FXSvgPathXmlConverter
implements Converter<ImmutableList<PathElement>> {
    public @Nullable ImmutableList<PathElement> fromString(@NonNull CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        CharBuffer out = CharBuffer.allocate(buf.remaining());
        int count = 0;
        try {
            count = buf.read(out);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        out.position(0);
        out.limit(count);
        String string = out.toString();
        if ("none".equals(string)) {
            return null;
        }
        return VectorList.copyOf((Iterable)FXSvgPaths.pathElementsFromSvgString((String)string));
    }

    public <TT extends ImmutableList<PathElement>> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        String content = value == null ? null : FXSvgPaths.doubleSvgStringFromPathElements((List)value.asList());
        out.append(content == null ? "none" : content);
    }

    public @Nullable ImmutableList<PathElement> getDefaultValue() {
        return VectorList.of();
    }
}

