/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.xml.converter;

import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.io.CharBufferReader;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.geom.shape.PathMetrics;
import org.jhotdraw8.geom.shape.PathMetricsBuilder;
import org.jhotdraw8.geom.shape.SimplePathMetrics;

public class PathMetricsXmlConverter
implements Converter<PathMetrics> {
    private final boolean nullable;

    public PathMetricsXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public @Nullable PathMetrics fromString(@NonNull CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        String input = buf.toString();
        buf.position(buf.limit());
        StreamCssTokenizer tt = new StreamCssTokenizer((Reader)new CharBufferReader(buf));
        SimplePathMetrics p = null;
        try {
            if (tt.next() == -2) {
                if (!this.nullable) {
                    throw new ParseException("String expected. " + tt.current(), buf.position());
                }
                if ("none".equals(tt.currentString())) {
                    buf.position(buf.limit());
                    return null;
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        PathMetricsBuilder builder = new PathMetricsBuilder();
        SvgPaths.svgStringToBuilder((String)input, (PathBuilder)builder);
        p = builder.build();
        return p;
    }

    public <TT extends PathMetrics> void toString(@NonNull Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            if (!this.nullable) {
                throw new IllegalArgumentException("value");
            }
            out.append("none");
            return;
        }
        out.append(SvgPaths.awtPathIteratorToDoubleSvgString((PathIterator)value.getPathIterator(null)));
    }

    public @Nullable PathMetrics getDefaultValue() {
        return this.nullable ? null : new PathMetricsBuilder().build();
    }
}

