/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw;

import java.util.HashSet;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.draw.tool.ToolEvent;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.undo.FXUndoManager;

public abstract class AbstractDrawingEditor
implements DrawingEditor {
    private final @NonNull ObjectProperty<String> helpText = new SimpleObjectProperty((Object)this, "helpText");
    private final @NonNull NonNullObjectProperty<FXUndoManager> undoManager = new NonNullObjectProperty((Object)this, "undoManager", (Object)new FXUndoManager());
    private final @NonNull DoubleProperty handleSize = new SimpleDoubleProperty(this, "handleSize", 5.0){

        public void set(double newValue) {
            super.set(newValue);
            AbstractDrawingEditor.this.recreateHandles();
        }
    };
    private final @NonNull DoubleProperty tolerance = new SimpleDoubleProperty(this, "tolerance", 5.0){

        public void set(double newValue) {
            super.set(newValue);
            AbstractDrawingEditor.this.recreateHandles();
        }
    };
    private final @NonNull DoubleProperty handleStrokeWidth = new SimpleDoubleProperty(this, "handleStrokeWidth", 1.0){

        public void set(double newValue) {
            super.set(newValue);
            AbstractDrawingEditor.this.recreateHandles();
        }
    };
    private final @NonNull NonNullObjectProperty<CssColor> handleColor = new NonNullObjectProperty<CssColor>((Object)this, "handleColor", CssColor.valueOf("blue")){

        public void set(CssColor newValue) {
            super.set((Object)newValue);
            AbstractDrawingEditor.this.recreateHandles();
        }
    };
    private final NonNullObjectProperty<HandleType> handleType = new NonNullObjectProperty((Object)this, "handleType", (Object)HandleType.RESIZE);
    private final ObjectProperty<HandleType> leadHandleType = new SimpleObjectProperty((Object)this, "handleType", (Object)HandleType.RESIZE);
    private final ObjectProperty<HandleType> anchorHandleType = new SimpleObjectProperty((Object)this, "handleType", (Object)HandleType.RESIZE);
    private final NonNullObjectProperty<HandleType> multiHandleType = new NonNullObjectProperty((Object)this, "multiHandleType", (Object)HandleType.SELECT);
    private final SetProperty<DrawingView> drawingViews = new SimpleSetProperty((Object)this, "drawingViews", FXCollections.observableSet(new HashSet()));
    private final ChangeListener<Boolean> focusListener = (observable, oldValue, newValue) -> {
        if (newValue.booleanValue()) {
            this.setActiveDrawingView((DrawingView)((ReadOnlyProperty)observable).getBean());
        }
    };
    private final @Nullable Listener<ToolEvent> defaultToolActivator = event -> {
        switch (event.getEventType()) {
            case TOOL_DONE: {
                if (this.getDefaultTool() == event.getSource() || this.getDefaultTool() == null) break;
                this.setActiveTool(this.getDefaultTool());
                break;
            }
        }
    };
    private final ObjectProperty<DrawingView> activeDrawingView = new SimpleObjectProperty((Object)this, "activeDrawingView");
    private final ObjectProperty<Tool> activeTool = new SimpleObjectProperty((Object)this, "activeTool");
    private final ObjectProperty<Tool> defaultTool = new SimpleObjectProperty((Object)this, "defaultTool");

    public AbstractDrawingEditor() {
        ChangeListener recreateHandles = (observable, oldValue, newValue) -> this.recreateHandles();
        this.multiHandleType.addListener(recreateHandles);
        this.handleType.addListener(recreateHandles);
        this.drawingViews.addListener(change -> {
            if (change.wasRemoved()) {
                DrawingView removed = (DrawingView)change.getElementRemoved();
                removed.setEditor(null);
                removed.focusedProperty().removeListener(this.focusListener);
                if (this.getActiveDrawingView() != null && this.getActiveDrawingView() == removed) {
                    this.setActiveDrawingView(this.drawingViews.isEmpty() ? null : (DrawingView)((ObservableSet)this.drawingViews.get()).iterator().next());
                }
                removed.setTool(null);
            } else if (change.wasAdded()) {
                DrawingView added = (DrawingView)change.getElementAdded();
                added.focusedProperty().addListener(this.focusListener);
                if (added.getEditor() != null) {
                    added.getEditor().removeDrawingView(added);
                }
                added.setEditor(this);
                Tool theActiveTool = this.getActiveTool();
                added.setTool(theActiveTool);
                if (this.drawingViews.size() == 1) {
                    this.setActiveDrawingView(added);
                }
            }
        });
        this.activeTool.addListener((o, oldValue, newValue) -> {
            if (this.getActiveDrawingView() != null) {
                this.getActiveDrawingView().setTool((Tool)newValue);
            }
            if (oldValue != null) {
                oldValue.deactivate(this);
                oldValue.removeToolListener(this.defaultToolActivator);
            }
            if (newValue != null) {
                newValue.addToolListener(this.defaultToolActivator);
                newValue.setDrawingEditor(this);
                newValue.activate(this);
            }
        });
    }

    @Override
    public @NonNull ObjectProperty<DrawingView> activeDrawingViewProperty() {
        return this.activeDrawingView;
    }

    @Override
    public @NonNull ObjectProperty<Tool> activeToolProperty() {
        return this.activeTool;
    }

    @Override
    public @NonNull ObjectProperty<HandleType> anchorHandleTypeProperty() {
        return this.anchorHandleType;
    }

    @Override
    public @NonNull ObjectProperty<Tool> defaultToolProperty() {
        return this.defaultTool;
    }

    public @NonNull SetProperty<DrawingView> drawingViewsProperty() {
        return this.drawingViews;
    }

    @Override
    public @NonNull NonNullObjectProperty<CssColor> handleColorProperty() {
        return this.handleColor;
    }

    @Override
    public @NonNull DoubleProperty handleSizeProperty() {
        return this.handleSize;
    }

    @Override
    public @NonNull DoubleProperty handleStrokeWidthProperty() {
        return this.handleStrokeWidth;
    }

    @Override
    public @NonNull NonNullObjectProperty<HandleType> handleTypeProperty() {
        return this.handleType;
    }

    @Override
    public @NonNull ObjectProperty<String> helpTextProperty() {
        return this.helpText;
    }

    @Override
    public @NonNull ObjectProperty<HandleType> leadHandleTypeProperty() {
        return this.leadHandleType;
    }

    @Override
    public @NonNull NonNullObjectProperty<HandleType> multiHandleTypeProperty() {
        return this.multiHandleType;
    }

    @Override
    public @NonNull DoubleProperty toleranceProperty() {
        return this.tolerance;
    }

    @Override
    public @NonNull NonNullObjectProperty<FXUndoManager> undoManagerProperty() {
        return this.undoManager;
    }
}

