/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.constrain.Constrainer;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Figures;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.input.ClipboardInputFormat;
import org.jhotdraw8.draw.input.ClipboardOutputFormat;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.render.WritableRenderContext;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.geom.FXTransforms;

public interface DrawingView
extends WritableRenderContext {
    public static final @NonNull String MODEL_PROPERTY = "model";
    public static final @NonNull String TOOL_PROPERTY = "tool";
    public static final @NonNull String FOCUSED_PROPERTY = "focused";
    public static final @NonNull String ZOOM_FACTOR_PROPERTY = "zoomFactor";
    public static final @NonNull String CONSTRAINER_PROPERTY = "constrainer";
    public static final @NonNull String SELECTED_FIGURES_PROPERTY = "selectedFigures";
    public static final @NonNull String ACTIVE_HANDLE_PROPERTY = "activeHandle";
    public static final @NonNull String ACTIVE_PARENT_PROPERTY = "activeLayer";
    public static final @NonNull String CLIPBOARD_INPUT_FORMAT_PROPERTY = "clipboardInputFormat";
    public static final @NonNull String CLIPBOARD_OUTPUT_FORMAT_PROPERTY = "clibpoardOutputFormat";
    public static final @NonNull String DRAWING_PROPERTY = "drawing";
    public static final @NonNull String EDITOR_PROPERTY = "editor";

    public @NonNull NonNullObjectProperty<DrawingModel> modelProperty();

    public @NonNull ReadOnlyObjectProperty<Drawing> drawingProperty();

    public @NonNull ObjectProperty<DrawingEditor> editorProperty();

    public @NonNull ObjectProperty<Figure> activeParentProperty();

    default public void scrollSelectedFiguresToVisible() {
        ObservableSet<Figure> selectedFigures = this.getSelectedFigures();
        if (!selectedFigures.isEmpty()) {
            this.scrollRectToVisible(this.worldToView(Figures.getBoundsInWorld(selectedFigures)));
        }
    }

    public @NonNull ObjectProperty<Tool> toolProperty();

    public @NonNull DoubleProperty zoomFactorProperty();

    public @NonNull NonNullObjectProperty<Constrainer> constrainerProperty();

    public @NonNull ReadOnlyBooleanProperty focusedProperty();

    public @NonNull ReadOnlySetProperty<Figure> selectedFiguresProperty();

    public @NonNull ReadOnlySetProperty<Handle> handlesProperty();

    public @NonNull ObjectProperty<Handle> activeHandleProperty();

    public @NonNull ObjectProperty<ClipboardOutputFormat> clipboardOutputFormatProperty();

    public @NonNull ObjectProperty<ClipboardInputFormat> clipboardInputFormatProperty();

    public Node getNode();

    @Override
    public @Nullable Node getNode(Figure var1);

    public @Nullable Handle findHandle(double var1, double var3);

    default public @Nullable Figure findFigure(double vx, double vy, Set<Figure> figures) {
        List<Map.Entry<Figure, Double>> result = this.findFigures(vx, vy, false, figures::contains);
        return this.getClosestFigure(result);
    }

    default public Figure getClosestFigure(List<Map.Entry<Figure, Double>> result) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Figure closestFigure = null;
        for (Map.Entry<Figure, Double> entry : result) {
            if (!(entry.getValue() < closestDistance)) continue;
            closestDistance = entry.getValue();
            closestFigure = entry.getKey();
            if (closestDistance != 0.0) continue;
            break;
        }
        return closestFigure;
    }

    default public @Nullable Figure findFigure(double vx, double vy) {
        return this.findFigure(vx, vy, Figure::isSelectable);
    }

    default public @Nullable Figure findFigure(double vx, double vy, Predicate<Figure> predicate) {
        List<Map.Entry<Figure, Double>> result = this.findFigures(vx, vy, false, predicate);
        return this.getClosestFigure(result);
    }

    public @Nullable Node findFigureNode(@NonNull Figure var1, double var2, double var4);

    default public @NonNull List<Map.Entry<Figure, Double>> findFigures(double vx, double vy, boolean decompose) {
        return this.findFigures(vx, vy, decompose, Figure::isSelectable);
    }

    public @NonNull List<Map.Entry<Figure, Double>> findFigures(double var1, double var3, boolean var5, @NonNull Predicate<Figure> var6);

    public @NonNull List<Map.Entry<Figure, Double>> findFiguresInside(double var1, double var3, double var5, double var7, boolean var9);

    default public @NonNull List<Map.Entry<Figure, Double>> findFiguresIntersecting(double vx, double vy, double vwidth, double vheight, boolean decompose) {
        return this.findFiguresIntersecting(vx, vy, vwidth, vheight, decompose, f -> true);
    }

    public @NonNull List<Map.Entry<Figure, Double>> findFiguresIntersecting(double var1, double var3, double var5, double var7, boolean var9, Predicate<Figure> var10);

    public @NonNull Set<Figure> getFiguresWithCompatibleHandle(Collection<Figure> var1, Handle var2);

    public @NonNull Transform getWorldToView();

    public @NonNull Transform getViewToWorld();

    default public @Nullable Figure findFigure(@NonNull Point2D pointInView) {
        return this.findFigure(pointInView.getX(), pointInView.getY());
    }

    default public @NonNull List<Map.Entry<Figure, Double>> findFigures(@NonNull Point2D pointInView, boolean decompose) {
        return this.findFigures(pointInView.getX(), pointInView.getY(), decompose);
    }

    default public @NonNull List<Map.Entry<Figure, Double>> findFiguresInside(@NonNull Rectangle2D rectangleInView, boolean decompose) {
        return this.findFiguresInside(rectangleInView.getMinX(), rectangleInView.getMinY(), rectangleInView.getWidth(), rectangleInView.getHeight(), decompose);
    }

    default public @NonNull List<Map.Entry<Figure, Double>> findFiguresIntersecting(@NonNull Rectangle2D rectangleInView, boolean decompose) {
        return this.findFiguresIntersecting(rectangleInView.getMinX(), rectangleInView.getMinY(), rectangleInView.getWidth(), rectangleInView.getHeight(), decompose, Figure::isSelectable);
    }

    default public void setDrawing(@Nullable Drawing newValue) {
        this.getModel().setRoot(newValue);
        this.setActiveParent(null);
    }

    default public @Nullable Drawing getDrawing() {
        return ((DrawingModel)this.modelProperty().get()).getDrawing();
    }

    default public void setEditor(@Nullable DrawingEditor newValue) {
        this.editorProperty().set((Object)newValue);
    }

    default public @Nullable DrawingEditor getEditor() {
        return (DrawingEditor)this.editorProperty().get();
    }

    default public void setConstrainer(@NonNull Constrainer newValue) {
        this.constrainerProperty().set((Object)newValue);
    }

    default public @NonNull Constrainer getConstrainer() {
        return (Constrainer)this.constrainerProperty().get();
    }

    default public void setTool(@Nullable Tool newValue) {
        this.toolProperty().set((Object)newValue);
    }

    default public @Nullable Tool getTool() {
        return (Tool)this.toolProperty().get();
    }

    default public void setActiveHandle(@Nullable Handle newValue) {
        this.activeHandleProperty().set((Object)newValue);
    }

    default public @Nullable Handle getActiveHandle() {
        return (Handle)this.activeHandleProperty().get();
    }

    default public @Nullable Figure getSelectionLead() {
        ArrayList<Figure> selection = new ArrayList<Figure>((Collection<Figure>)this.getSelectedFigures());
        return selection.isEmpty() ? null : selection.getLast();
    }

    default public @Nullable Figure getSelectionAnchor() {
        ObservableSet<Figure> selection = this.getSelectedFigures();
        return selection.isEmpty() ? null : (Figure)selection.iterator().next();
    }

    default public void setActiveParent(@Nullable Figure newValue) {
        this.activeParentProperty().set((Object)newValue);
    }

    default public @Nullable Figure getActiveParent() {
        return (Figure)this.activeParentProperty().get();
    }

    default public void setZoomFactor(double newValue) {
        this.zoomFactorProperty().set(newValue);
    }

    default public double getZoomFactor() {
        return this.zoomFactorProperty().get();
    }

    default public ObservableSet<Figure> getSelectedFigures() {
        return (ObservableSet)this.selectedFiguresProperty().get();
    }

    default public ObservableSet<Handle> getHandles() {
        return (ObservableSet)this.handlesProperty().get();
    }

    default public Point2D viewToWorld(@NonNull Point2D view) {
        return FXTransforms.transform((Transform)this.getViewToWorld(), (Point2D)view);
    }

    default public Bounds viewToWorld(@NonNull Bounds view) {
        return this.getViewToWorld().transform(view);
    }

    default public Point2D worldToView(@NonNull Point2D world) {
        return FXTransforms.transform((Transform)this.getWorldToView(), (Point2D)world);
    }

    default public Bounds worldToView(@NonNull Bounds world) {
        return this.getWorldToView().transform(world);
    }

    default public Point2D viewToWorld(double vx, double vy) {
        return this.getViewToWorld().transform(vx, vy);
    }

    default public Point2D worldToView(double dx, double dy) {
        return this.getWorldToView().transform(dx, dy);
    }

    default public DrawingModel getModel() {
        return (DrawingModel)this.modelProperty().get();
    }

    default public void setModel(DrawingModel newValue) {
        this.modelProperty().set((Object)newValue);
    }

    default public void setClipboardOutputFormat(@Nullable ClipboardOutputFormat newValue) {
        this.clipboardOutputFormatProperty().set((Object)newValue);
    }

    default public void setClipboardInputFormat(@Nullable ClipboardInputFormat newValue) {
        this.clipboardInputFormatProperty().set((Object)newValue);
    }

    default public @Nullable ClipboardOutputFormat getClipboardOutputFormat() {
        return (ClipboardOutputFormat)this.clipboardOutputFormatProperty().get();
    }

    default public @Nullable ClipboardInputFormat getClipboardInputFormat() {
        return (ClipboardInputFormat)this.clipboardInputFormatProperty().get();
    }

    public void recreateHandles();

    public void jiggleHandles();

    default public void scrollFigureToVisible(@NonNull Figure f) {
        Bounds boundsInView = this.worldToView(f.getLayoutBoundsInWorld());
        this.scrollRectToVisible(boundsInView);
    }

    public void scrollRectToVisible(Bounds var1);

    public Bounds getVisibleRect();
}

