/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class AddToGroupAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.addToGroup";

    public AddToGroupAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView drawingView) {
        ArrayList<Figure> figures = new ArrayList<Figure>((Collection<Figure>)drawingView.getSelectedFigures());
        AddToGroupAction.addToGroup(drawingView, figures);
    }

    public static void addToGroup(@NonNull DrawingView view, @NonNull List<Figure> figures) {
        if (figures.size() < 2) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "You must select the figures and a group to which the figures should be added", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            return;
        }
        Figure lead = figures.getLast();
        if (!(lead instanceof Grouping) && !lead.isAllowsChildren() || !lead.isDecomposable()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "The last figure in the selection must be a group.", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            return;
        }
        if (!lead.isEditable()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "The last figure in the selection is not editable.", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            return;
        }
        ArrayList<Figure> reparentableFigures = new ArrayList<Figure>();
        int n = figures.size() - 1;
        for (int i = 0; i < n; ++i) {
            Figure f = figures.get(i);
            if (!(f.isEditable() && f.isSuitableParent(lead) && f.getParent() != null && f.getParent().isEditable() && f.getParent().isDecomposable())) {
                if (f instanceof StyleableFigure && f.get((MapAccessor)StyleableFigure.ID) != null) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "The figure with id \"" + (String)f.get((MapAccessor)StyleableFigure.ID) + "\" can not be added to the group.", new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.showAndWait();
                } else {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "One of the selected figures can not be added to the group.", new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.showAndWait();
                }
                return;
            }
            reparentableFigures.add(f);
        }
        DrawingModel m = view.getModel();
        for (Figure f : reparentableFigures) {
            m.addChildTo(f, lead);
        }
    }
}

