/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.geom.FXTransforms;

public class AlignHorizontalAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.alignHorizontal";

    public AlignHorizontalAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView drawingView) {
        ObservableSet<Figure> figures = drawingView.getSelectedFigures();
        Figure lead = drawingView.getSelectionLead();
        this.alignHorizontal(drawingView, (Set<Figure>)figures, lead);
    }

    private void alignHorizontal(@NonNull DrawingView view, @NonNull Set<Figure> figures, @Nullable Figure lead) {
        if (figures.size() < 2 || lead == null) {
            return;
        }
        DrawingModel model = view.getModel();
        Bounds leadBounds = lead.getLayoutBoundsInWorld();
        double yInWorld = leadBounds.getMinY() + leadBounds.getHeight() * 0.5;
        Point2D yPointInWorld = new Point2D(0.0, yInWorld);
        for (Figure f : figures) {
            if (f == lead || !f.isEditable()) continue;
            double desiredY = FXTransforms.transform((Transform)f.getWorldToParent(), (Point2D)yPointInWorld).getY();
            Bounds bounds = f.getLayoutBoundsInParent();
            double actualY = bounds.getMinY() + bounds.getHeight() * 0.5;
            double dy = desiredY - actualY;
            Translate tx = new Translate(0.0, dy);
            model.transformInParent(f, (Transform)tx);
            model.fireLayoutInvalidated(f);
        }
    }
}

