/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.geometry.Bounds;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;

public class DistributeHorizontallyAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.distributeHorizontally";

    public DistributeHorizontallyAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView drawingView) {
        ObservableSet<Figure> figures = drawingView.getSelectedFigures();
        this.distributeHorizontally(drawingView, (Set<Figure>)figures);
    }

    private void distributeHorizontally(@NonNull DrawingView view, @NonNull Set<Figure> figures) {
        if (figures.size() < 3) {
            return;
        }
        DrawingModel model = view.getModel();
        double maxX = Double.NEGATIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>();
        block0: for (Figure f : figures) {
            for (Figure subject : f.getLayoutSubjects()) {
                if (!figures.contains(subject)) continue;
                continue block0;
            }
            Bounds b = f.getLayoutBoundsInWorld();
            double cx = b.getMinX() + b.getWidth() * 0.5;
            list.add(new AbstractMap.SimpleEntry<Double, Figure>(cx, f));
            maxX = Math.max(maxX, cx);
            minX = Math.min(minX, cx);
        }
        list.sort(Comparator.comparingDouble(Map.Entry::getKey));
        double extent = maxX - minX;
        double count = figures.size();
        double index = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double newcx = minX + extent * index / (count - 1.0);
            Map.Entry e = (Map.Entry)iterator.next();
            Figure f = (Figure)e.getValue();
            Bounds b = f.getLayoutBoundsInWorld();
            double oldcx = b.getMinX() + b.getWidth() * 0.5;
            double dx = newcx - oldcx;
            if (dx != 0.0) {
                Translate tx = new Translate(dx, 0.0);
                model.transformInParent(f, (Transform)tx);
                model.fireLayoutInvalidated(f);
            }
            index += 1.0;
        }
    }
}

