/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class RemoveFromGroupAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.removeFromGroup";

    public RemoveFromGroupAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView drawingView) {
        ArrayList<Figure> figures = new ArrayList<Figure>((Collection<Figure>)drawingView.getSelectedFigures());
        this.removeFromGroup(drawingView, figures);
    }

    public void removeFromGroup(@NonNull DrawingView view, @NonNull List<Figure> figures) {
        ArrayList<Figure> reparentableFigures = new ArrayList<Figure>();
        for (Figure f : figures) {
            Layer layer = (Layer)f.getAncestor(Layer.class);
            if (!layer.isEditable()) continue;
            if (f.getParent() != null && f.getParent().isDecomposable() && f.getParent().isEditable() && f.getParent() instanceof Grouping) {
                if (f.isEditable()) {
                    reparentableFigures.add(f);
                    continue;
                }
                if (f instanceof StyleableFigure && f.get((MapAccessor)StyleableFigure.ID) != null) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "The figure with id \"" + (String)f.get((MapAccessor)StyleableFigure.ID) + "\" can not be removed from the group.", new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.showAndWait();
                } else {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "One of the selected figures can not be removed from the group.", new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.showAndWait();
                }
                return;
            }
            if (f instanceof StyleableFigure && f.get((MapAccessor)StyleableFigure.ID) != null) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION, "The figure with id \"" + (String)f.get((MapAccessor)StyleableFigure.ID) + "\" is not inside an editable group.", new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
            } else {
                Alert alert = new Alert(Alert.AlertType.INFORMATION, "One of the selected figures is not inside an editable group.", new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
            }
            return;
        }
        DrawingModel m = view.getModel();
        for (Figure f : reparentableFigures) {
            Layer layer = (Layer)f.getAncestor(Layer.class);
            m.addChildTo(f, layer);
        }
    }
}

