/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.connector;

import java.awt.geom.PathIterator;
import javafx.geometry.Point2D;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.draw.connector.LocatorConnector;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.intersect.IntersectLinePathIterator;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;

public class PathConnector
extends LocatorConnector {
    public PathConnector() {
        super(BoundsLocator.CENTER);
    }

    public PathConnector(Locator locator) {
        super(locator);
    }

    @Override
    public IntersectionPointEx intersect(@NonNull RenderContext ctx, Figure connection, @NonNull Figure target, @NonNull Point2D start, @NonNull Point2D end) {
        PathIterator pit;
        if (!(target instanceof PathIterableFigure)) {
            return super.intersect(ctx, connection, target, start, end);
        }
        PathIterableFigure pif = (PathIterableFigure)target;
        Point2D s = target.worldToLocal(start);
        Point2D e = target.worldToLocal(end);
        if (target.getStyled((MapAccessor)StrokableFigure.STROKE) != null) {
            pit = switch ((StrokeType)target.getStyledNonNull((NonNullMapAccessor)StrokableFigure.STROKE_TYPE)) {
                default -> pif.getPathIterator(ctx, null);
                case StrokeType.INSIDE -> pif.getPathIterator(ctx, null);
            };
        } else {
            pit = pif.getPathIterator(ctx, null);
        }
        IntersectionResultEx i = IntersectLinePathIterator.intersectLinePathIteratorEx((double)s.getX(), (double)s.getY(), (double)e.getX(), (double)e.getY(), (PathIterator)pit);
        return (IntersectionPointEx)i.intersections().peekLast();
    }
}

