/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.BoundingBox;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class BoundingBoxCssConverter
extends AbstractCssConverter<BoundingBox> {
    private final boolean withSpace;
    private final boolean withComma;

    public BoundingBoxCssConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public BoundingBoxCssConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace || !withComma;
        this.withComma = withComma;
    }

    public @NonNull BoundingBox parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-9, " \u27e8BoundingBox\u27e9: \u27e8min-x\u27e9 expected.");
        double x = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8BoundingBox\u27e9: \u27e8min-y\u27e9 expected.");
        double y = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8BoundingBox\u27e9: \u27e8width\u27e9 expected.");
        double width = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8BoundingBox\u27e9: \u27e8height\u27e9 expected.");
        double height = tt.currentNumberNonNull().doubleValue();
        return new BoundingBox(x, y, width, height);
    }

    protected <TT extends BoundingBox> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-9, (Number)value.getMinX()));
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
        out.accept(new CssToken(-9, (Number)value.getMinY()));
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
        out.accept(new CssToken(-9, (Number)value.getWidth()));
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
        out.accept(new CssToken(-9, (Number)value.getHeight()));
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8BoundingBox\u27e9: \u27e8min-x\u27e9 \u27e8min-y\u27e9 \u27e8width\u27e9 \u27e8height\u27e9";
    }
}

