/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssDefaultableValue;
import org.jhotdraw8.css.value.CssDefaulting;

public class DefaultableValueCssConverter<T>
implements CssConverter<CssDefaultableValue<T>> {
    private final CssConverter<T> valueConverter;

    public DefaultableValueCssConverter(CssConverter<T> valueConverter) {
        this.valueConverter = valueConverter;
    }

    public @Nullable CssDefaultableValue<T> parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() == -2) {
            switch (tt.currentStringNonNull()) {
                case "inherit": {
                    return new CssDefaultableValue(CssDefaulting.INHERIT, null);
                }
                case "revert": {
                    return new CssDefaultableValue(CssDefaulting.REVERT, null);
                }
                case "initial": {
                    return new CssDefaultableValue(CssDefaulting.INITIAL, null);
                }
                case "unset": {
                    return new CssDefaultableValue(CssDefaulting.UNSET, null);
                }
            }
        }
        tt.pushBack();
        return new CssDefaultableValue(null, this.valueConverter.parse(tt, idResolver));
    }

    public <TT extends CssDefaultableValue<T>> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) throws IOException {
        if (value == null) {
            out.accept(new CssToken(-2, "none"));
            return;
        }
        CssDefaulting defaulting = value.getDefaulting();
        if (defaulting != null) {
            switch (defaulting) {
                case INITIAL: {
                    out.accept(new CssToken(-2, "initial"));
                    break;
                }
                case INHERIT: {
                    out.accept(new CssToken(-2, "inherit"));
                    break;
                }
                case UNSET: {
                    out.accept(new CssToken(-2, "unset"));
                    break;
                }
                case REVERT: {
                    out.accept(new CssToken(-2, "revert"));
                }
            }
            return;
        }
        this.valueConverter.produceTokens(value.getValue(), idSupplier, out);
    }

    public @Nullable CssDefaultableValue<T> getDefaultValue() {
        return new CssDefaultableValue(CssDefaulting.INHERIT, null);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8DefaultableValue\u27e9: \u27e8Value\u27e9\uff5cinherit\uff5cinitial\uff5cunset\uff5crevert\uff5c\nWith \u27e8Value\u27e9:\n  " + this.valueConverter.getHelpText();
    }

    public boolean isNullable() {
        return this.valueConverter.isNullable();
    }
}

