/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssDimension2D;

public class Dimension2DCssConverter
extends AbstractCssConverter<CssDimension2D> {
    private final boolean withSpace;
    private final boolean withComma;

    public Dimension2DCssConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public Dimension2DCssConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace || !withComma;
        this.withComma = withComma;
    }

    public @NonNull CssDimension2D parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        CssSize x = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"x");
        tt.skipIfPresent(44);
        CssSize y = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"y");
        return new CssDimension2D(x, y);
    }

    protected <TT extends CssDimension2D> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        CssSize x = value.getWidth();
        out.accept(new CssToken(-11, (Number)x.getValue(), x.getUnits()));
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
        CssSize y = value.getHeight();
        out.accept(new CssToken(-11, (Number)y.getValue(), y.getUnits()));
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8CssDimension2D\u27e9: \u27e8x\u27e9 \u27e8y\u27e9";
    }
}

